/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import rnadesign.designapp.NanoTilerInterpreter;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.RnaTools;

public class ApplyModeWizard
implements GeneralWizard {
    private static final int COL_SIZE_NAME = 25;
    private static final String FRAME_TITLE = "Apply Mode Wizard";
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean finished = false;
    private JFrame frame = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private CommandApplication application;
    private Object3DGraphController graphController;
    private NanoTilerInterpreter interpreter;
    private JTextField fileField;
    private JTextField modeField;
    private JTextField scaleField;
    private JTextField stepsField;
    private JLabel label;
    private Vector<String> tree;
    private String[] allowedNames = RnaTools.getRnaClassNames();
    private String[] forbiddenNames;
    private JPanel treePanel;
    private JButton treeButton;
    private JList treeList;
    private JScrollPane treeScroll;

    public ApplyModeWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
        this.interpreter = (NanoTilerInterpreter)application.getInterpreter();
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void addComponents() {
        Container f = this.frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        JPanel temp = new JPanel();
        temp.add(new JLabel("File:"));
        this.fileField = new JTextField(25);
        temp.add(this.fileField);
        centerPanel.add(temp);
        temp = new JPanel();
        temp.add(new JLabel("Mode:"));
        this.modeField = new JTextField(25);
        this.modeField.setText("1");
        temp.add(this.modeField);
        centerPanel.add(temp);
        temp = new JPanel();
        temp.add(new JLabel("Scale:"));
        this.scaleField = new JTextField(25);
        this.scaleField.setText("5");
        temp.add(this.scaleField);
        centerPanel.add(temp);
        temp = new JPanel();
        temp.add(new JLabel("Steps:"));
        this.stepsField = new JTextField(25);
        this.stepsField.setText("5");
        temp.add(this.stepsField);
        centerPanel.add(temp);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton button = new JButton("Close");
        button.addActionListener(new CancelListener());
        buttonPanel.add(button);
        button = new JButton("Done");
        button.addActionListener(new ApplyModeListener());
        buttonPanel.add(button);
        f.add((Component)centerPanel, "Center");
        f.add((Component)buttonPanel, "South");
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController controller, Component parentFrame) {
        this.frame = new JFrame(FRAME_TITLE);
        if (controller == null) {
            log.info("GraphController received by lauchWizard is null!");
        }
        this.graphController = controller;
        this.addComponents();
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    private class ApplyModeListener
    implements ActionListener {
        private ApplyModeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = "applymode mode=" + ApplyModeWizard.this.modeField.getText().trim() + " scale=" + ApplyModeWizard.this.scaleField.getText().trim() + " steps=" + ApplyModeWizard.this.stepsField.getText().trim();
            if (!ApplyModeWizard.this.fileField.getText().trim().equals("")) {
                command = command + " file=" + ApplyModeWizard.this.fileField.getText().trim();
            }
            try {
                ApplyModeWizard.this.application.runScriptLine(command);
            }
            catch (CommandException ce) {
                JOptionPane.showMessageDialog(ApplyModeWizard.this.frame, ce + ": " + ce.getMessage());
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ApplyModeWizard.this.frame.setVisible(false);
            ApplyModeWizard.this.frame = null;
            ApplyModeWizard.this.finished = true;
        }
    }
}

