/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import generaltools.Letter;
import java.awt.Color;
import java.util.Properties;
import rnadesign.designapp.rnagui.PaintStyle;
import rnadesign.designapp.rnagui.Painter;
import rnadesign.rnacontrol.CameraController;
import rnadesign.rnacontrol.SimpleCameraController;
import tools3d.Ambiente;
import tools3d.Drawable;

public abstract class AbstractPainter
implements Painter {
    Ambiente ambiente = null;
    CameraController cameraController = new SimpleCameraController();
    PaintStyle paintStyle = new PaintStyle();
    Color defaultPaintColor = Color.green;
    Color[] defaultPaintColors = new Color[]{Color.red, Color.yellow, Color.green, Color.blue};
    Color defaultCharacterColor = Color.black;

    @Override
    public Ambiente getAmbiente() {
        return this.ambiente;
    }

    @Override
    public CameraController getCameraController() {
        return this.cameraController;
    }

    @Override
    public Color getDefaultPaintColor() {
        return this.defaultPaintColor;
    }

    public Color getDefaultCharacterColor() {
        return this.defaultCharacterColor;
    }

    public Color getDefaultPaintColor(int depth) {
        if (depth >= 0 && depth < this.defaultPaintColors.length) {
            return this.defaultPaintColors[depth];
        }
        return this.getDefaultPaintColor();
    }

    public Color getDefaultPaintColor(Drawable drawable) {
        String depthString;
        Properties properties = drawable.getProperties();
        Color col = null;
        if (drawable instanceof Letter) {
            col = this.getDefaultCharacterColor();
        } else if (properties != null && (depthString = properties.getProperty("depth")) != null) {
            int depth = Integer.parseInt(depthString);
            col = this.getDefaultPaintColor(depth);
        }
        if (col == null) {
            col = this.getDefaultPaintColor();
        }
        col = drawable.isSelected() ? col.brighter() : col.darker();
        return col;
    }

    @Override
    public PaintStyle getPaintStyle() {
        return this.paintStyle;
    }

    @Override
    public void setAmbiente(Ambiente ambiente) {
        this.ambiente = ambiente;
    }

    @Override
    public void setCameraController(CameraController camera) {
        this.cameraController = camera;
    }

    @Override
    public void setDefaultPaintColor(Color color) {
        this.defaultPaintColor = color;
    }

    @Override
    public void setPaintStyle(PaintStyle style) {
        this.paintStyle = style;
    }
}

