/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.util.logging.Level;
import java.util.logging.Logger;
import rnadesign.designapp.PackageConstants;

public class VerboseCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "verbose";
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private String name;

    public VerboseCommand() {
        super(COMMAND_NAME);
    }

    @Override
    public Object cloneDeep() {
        VerboseCommand command = new VerboseCommand();
        command.name = this.name;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: verbose all|finest|fine|info|warning|severe|off";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"verbose\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " all|finest|fine|info|warning|severe|off" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Verbose command TODO" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        if (this.name == null) throw new CommandExecutionException("Bad command syntax! " + this.helpOutput());
        if (this.name.equals("all")) {
            log.setLevel(Level.ALL);
            return;
        } else if (this.name.equals("fine")) {
            log.setLevel(Level.FINE);
            return;
        } else if (this.name.equals("finest")) {
            log.setLevel(Level.FINEST);
            return;
        } else if (this.name.equals("info")) {
            log.setLevel(Level.INFO);
            return;
        } else if (this.name.equals("warning")) {
            log.setLevel(Level.WARNING);
            return;
        } else if (this.name.equals("severe")) {
            log.setLevel(Level.SEVERE);
            return;
        } else {
            if (!this.name.equals("off")) throw new CommandExecutionException("Unknown command directive " + this.name + " " + this.helpOutput());
            log.setLevel(Level.OFF);
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() == 1) {
            StringParameter p0 = (StringParameter)this.getParameter(0);
            this.name = p0.getValue();
        } else if (this.getParameterCount() != 0) {
            throw new CommandExecutionException(this.helpOutput());
        }
    }
}

