/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.ParsingException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnacontrol.ScriptController;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.SimpleObject3DSet;
import tools3d.symmetry2.SymEdgeConstraint;

public class TraceRnaGraphScriptCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "tracegraphscript";
    private Object3DGraphController controller;
    private String algorithm = "helix";
    private String objectNames;
    private boolean kissingLoopMode = false;
    private String name = "traced";
    private String fileName;
    private List<SymEdgeConstraint> symConstraints;
    private Properties params = new Properties();

    public TraceRnaGraphScriptCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        TraceRnaGraphScriptCommand command = new TraceRnaGraphScriptCommand(this.controller);
        command.algorithm = this.algorithm;
        command.name = this.name;
        command.fileName = this.fileName;
        command.kissingLoopMode = this.kissingLoopMode;
        command.objectNames = this.objectNames;
        command.params = this.params;
        command.symConstraints = this.symConstraints;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: tracegraphscript graph=NAME file=FILENAME";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = this.getShortHelpText() + PackageConstants.NEWLINE + "\"" + COMMAND_NAME + "\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "graph=NAME  : full name of root node of graph to be traced." + PackageConstants.NEWLINE;
        helpText = helpText + "file=FILENAME  : file name of script that is being generated." + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Generates a script for tracing a graph with RNA helices." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    String[] parseNames(String name) {
        return name.split(";");
    }

    SymEdgeConstraint parseSymEdgeConstraint(String s) throws CommandExecutionException {
        String[] words = s.split(",");
        if (words.length != 5) {
            throw new CommandExecutionException("Expected 5 ids in edge symmetry constraint: id1, id2, origId1, origId2, symId");
        }
        SymEdgeConstraint result = null;
        try {
            result = new SymEdgeConstraint(Integer.parseInt(words[0]) - 1, Integer.parseInt(words[1]) - 1, Integer.parseInt(words[2]) - 1, Integer.parseInt(words[3]) - 1, Integer.parseInt(words[4]));
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Error parsing integer value in symmetry edge constraint descriptor: " + s);
        }
        return result;
    }

    List<SymEdgeConstraint> parseSymEdgeConstraints(String s) throws CommandExecutionException {
        ArrayList<SymEdgeConstraint> result = new ArrayList<SymEdgeConstraint>();
        String[] words = s.split(";");
        for (int i = 0; i < words.length; ++i) {
            result.add(this.parseSymEdgeConstraint(words[i]));
        }
        return result;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        if (this.name == null || this.name.equals("")) {
            throw new CommandExecutionException("Command select: Undefined object name. " + this.helpOutput());
        }
        try {
            Object3DController graphController = this.controller.getGraph();
            String[] names = this.parseNames(this.objectNames);
            SimpleObject3DSet objSet = new SimpleObject3DSet();
            for (String s : names) {
                Object3DSet objs = graphController.findAllByFullName(s);
                if (objs == null) {
                    throw new CommandExecutionException("Could not find object with name " + s);
                }
                objSet.merge(objs);
            }
            System.out.println("Generating graph trace script with " + objSet.size() + " vertices.");
            String result = ScriptController.generateGraphTraceScript(objSet.get(0), this.controller.getLinks(), this.name, this.symConstraints, this.params, this.algorithm, this.kissingLoopMode);
            System.out.println(result);
            FileOutputStream fos = new FileOutputStream(this.fileName);
            PrintStream ps = new PrintStream(fos);
            ps.println(result);
            fos.close();
            this.resultProperties.setProperty("output", result);
        }
        catch (IOException ioe) {
            throw new CommandExecutionException("IOException in tracegraphscript : " + ioe.getMessage());
        }
        catch (Object3DGraphControllerException gce) {
            throw new CommandExecutionException("Error retrieving objects: " + gce.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter klp;
        StringParameter minP;
        StringParameter maxP;
        StringParameter symP;
        StringParameter p1;
        StringParameter p0 = (StringParameter)this.getParameter("graph");
        if (p0 == null) {
            throw new CommandExecutionException(this.helpOutput());
        }
        this.objectNames = p0.getValue();
        StringParameter pa = (StringParameter)this.getParameter("alg");
        if (pa != null) {
            this.algorithm = pa.getValue();
        }
        if ((p1 = (StringParameter)this.getParameter("file")) == null) {
            throw new CommandExecutionException(this.helpOutput());
        }
        this.fileName = p1.getValue();
        StringParameter p2 = (StringParameter)this.getParameter("name");
        if (p2 != null) {
            this.name = p2.getValue();
        }
        if ((symP = (StringParameter)this.getParameter("sym")) != null) {
            this.symConstraints = this.parseSymEdgeConstraints(symP.getValue());
        }
        if ((maxP = (StringParameter)this.getParameter("max")) != null) {
            this.params.setProperty("max", maxP.getValue());
            log.info("changed max parameter to: " + this.params.getProperty("max"));
        }
        if ((minP = (StringParameter)this.getParameter("min")) != null) {
            this.params.setProperty("min", minP.getValue());
        }
        if ((klp = (StringParameter)this.getParameter("kl")) != null) {
            try {
                this.kissingLoopMode = klp.parseBoolean();
            }
            catch (ParsingException pe) {
                throw new CommandExecutionException(pe.getMessage());
            }
        }
    }
}

