/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.io.PrintStream;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;

public class StatusCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "status";
    private Object3DGraphController controller;
    private PrintStream ps;
    private String subcom = "";

    public StatusCommand(PrintStream ps, Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
        this.ps = ps;
    }

    @Override
    public Object cloneDeep() {
        StatusCommand command = new StatusCommand(this.ps, this.controller);
        command.ps = this.ps;
        command.controller = this.controller;
        command.subcom = this.subcom;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    private String helpOutput() {
        return "Correct usage: status [basepairs]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"status\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " FILENAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Status command displays the defined base pairs, junctions and kissing loop data. " + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    private void executeSingleBaseStatus() {
        if (this.controller.getNucleotideDB() == null) {
            System.out.println("No reference nucleotides are defined. Consider command loadnucleotides.");
        } else {
            Object3DSet nucs = Object3DTools.collectByClassName(this.controller.getNucleotideDB(), "Nucleotide3D");
            System.out.println("" + nucs.size());
            for (int i = 0; i < nucs.size(); ++i) {
                System.out.print(nucs.get(i).getName() + " ");
            }
            System.out.println();
        }
    }

    private void executeBasePairStatus() {
        this.ps.println(this.controller.getBasePairDB().toInfoString());
    }

    private void executeJunctionStatus() {
        this.ps.println(this.controller.getJunctionController().infoString());
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        if (this.subcom.equals("basepairs")) {
            this.executeBasePairStatus();
        } else if (this.subcom.equals("")) {
            this.ps.println("Status of read reference bases: " + PackageConstants.NEWLINE);
            this.executeSingleBaseStatus();
            this.ps.println("Status of read reference base pairs: " + PackageConstants.NEWLINE);
            this.executeBasePairStatus();
            this.ps.println("Status of read reference junctions and kissing loops: " + PackageConstants.NEWLINE);
            this.executeJunctionStatus();
        } else {
            throw new CommandExecutionException("Unknown command modifier: status " + this.subcom);
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() > 0) {
            StringParameter par1 = (StringParameter)this.getParameter(0);
            this.subcom = par1.getValue();
        }
    }
}

