/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.util.logging.Logger;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class SpaceGroupCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "spacegroup";
    private String name;
    private int number;
    private String convention;
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private Object3DGraphController controller;

    public SpaceGroupCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        SpaceGroupCommand command = new SpaceGroupCommand(this.controller);
        command.name = this.name;
        if (this.name != null) {
            command.name = this.name.substring(0, this.name.length());
        }
        command.number = this.number;
        if (this.convention != null) {
            command.convention = this.convention.substring(0, this.convention.length());
        }
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    private String helpOutput() {
        return "Correct usage: spacegroup name=<NAME> number=id convention=ccp4|Hall|xHM";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"spacegroup\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " [options]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Space group command TODO." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        helpText = helpText + "     name=NAME" + PackageConstants.NEWLINE + "          Set the name." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     number=INT" + PackageConstants.NEWLINE + "          TODO" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     convention=ccp4|Hall|xHM" + PackageConstants.NEWLINE + "          TODO" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        this.log.info("Readout values: " + this.number + " " + this.name + " " + this.convention);
        try {
            if (this.name != null) {
                if (this.convention != null) {
                    this.log.info("Calling: controller.setSpaceGroup(" + this.name + "," + this.convention + ")");
                    this.controller.setSpaceGroup(this.name, this.convention);
                } else {
                    this.log.info("Calling: controller.setSpaceGroup(" + this.name + "\")");
                    this.controller.setSpaceGroup(this.name);
                }
            } else {
                this.log.info("Calling: controller.setSpaceGroup(" + this.number + ")");
                this.controller.setSpaceGroup(this.number);
            }
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException("Error in command: " + this.toString() + " " + e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() != 1) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter namePar = (StringParameter)this.getParameter("name");
        StringParameter numberPar = (StringParameter)this.getParameter("number");
        StringParameter conventionPar = (StringParameter)this.getParameter("convention");
        if (namePar != null && numberPar != null) {
            throw new CommandExecutionException("Specify either space group name or number, but not both.");
        }
        if (namePar == null && numberPar == null) {
            throw new CommandExecutionException("Specify either space group name or number with name=\"name\" or number=id");
        }
        if (namePar != null) {
            this.name = namePar.getValue();
        }
        if (numberPar != null) {
            this.number = Integer.parseInt(numberPar.getValue());
        }
        if (conventionPar != null) {
            this.convention = conventionPar.getValue();
        }
    }
}

