/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.LinkController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class RemoveLinkCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "rmlink";
    private Object3DGraphController controller;
    private int linkId = 0;
    private String linkName;

    public RemoveLinkCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        RemoveLinkCommand command = new RemoveLinkCommand(this.controller);
        command.linkId = this.linkId;
        command.linkName = this.linkName;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: rmlink link-id|name=<name>";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "";
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "      " + this.helpOutput() + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " removes a link given a link number. Find link number with command \"links\"";
        helpText = helpText + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        LinkController linkController = this.controller.getLinks();
        if (this.linkName == null && (this.linkId < 0 || this.linkId >= linkController.size())) {
            throw new CommandExecutionException("Undefined link number: " + (this.linkId + 1));
        }
        try {
            if (this.linkName == null) {
                linkController.remove(this.linkId);
            } else {
                linkController.remove(this.linkName);
            }
        }
        catch (Object3DGraphControllerException gce) {
            throw new CommandExecutionException(gce.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() == 0) {
            throw new CommandExecutionException(this.helpOutput());
        }
        if (this.getParameterCount() == 1) {
            StringParameter pName = (StringParameter)this.getParameter("name");
            if (pName != null) {
                this.linkName = pName.getValue();
            } else {
                StringParameter p0 = (StringParameter)this.getParameter(0);
                try {
                    this.linkId = Integer.parseInt(p0.toString()) - 1;
                }
                catch (NumberFormatException nfe) {
                    throw new CommandExecutionException("Error parsing integer value: " + p0.toString());
                }
            }
        } else {
            throw new CommandExecutionException(this.helpOutput());
        }
    }
}

