/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class RandomizeCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "randomize";
    private Object3DGraphController controller;
    private String name;
    private String mode;
    private double scale = 10.0;

    public RandomizeCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        RandomizeCommand command = new RandomizeCommand(this.controller);
        command.name = this.name;
        command.mode = this.mode;
        command.scale = this.scale;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: randomize name [mode=rotate|translate][scale=VALUE]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"randomize\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " NAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Randomize command randomizes orientation of an object." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        if (this.name != null) {
            try {
                this.controller.getGraph().randomize(this.name, this.mode, this.scale);
                this.controller.refreshLinks();
            }
            catch (Object3DGraphControllerException e) {
                throw new CommandExecutionException(e.getMessage());
            }
        } else {
            throw new CommandExecutionException(this.helpOutput());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() <= 0) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        this.name = p0.getValue();
        StringParameter pmode = (StringParameter)this.getParameter("mode");
        if (pmode != null) {
            this.mode = pmode.getValue();
        }
        try {
            StringParameter pScale = (StringParameter)this.getParameter("scale");
            if (pScale != null) {
                this.scale = Double.parseDouble(pScale.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Error parsing command line option for command randomize: " + nfe.getMessage());
        }
    }
}

