/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import controltools.ModelChangeEvent;
import graphtools.IntegerPermutatorList;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import tools3d.SystematicMutator2;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.SimpleObject3DSet;

public class OptimizeSystematicCommand
extends AbstractCommand {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final String COMMAND_NAME = "optsystematic";
    private boolean addHelicesFlag = true;
    private double electrostaticWeight = 0.0;
    private String helixRootName = "root";
    private List<Object3DSet> objectBlocks;
    private int outputInterval = 10000;
    private IntegerPermutatorList permutators;
    private double errorScoreLimit = 0.0;
    private Object3DGraphController controller;
    private PrintStream ps;
    private double vdwWeight = 0.0;

    public OptimizeSystematicCommand(Object3DGraphController controller, PrintStream ps) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
        this.ps = ps;
    }

    @Override
    public Object cloneDeep() {
        OptimizeSystematicCommand command = new OptimizeSystematicCommand(this.controller, this.ps);
        command.addHelicesFlag = this.addHelicesFlag;
        command.electrostaticWeight = this.electrostaticWeight;
        command.helixRootName = this.helixRootName;
        command.objectBlocks = this.objectBlocks;
        command.outputInterval = this.outputInterval;
        command.permutators = this.permutators;
        command.errorScoreLimit = this.errorScoreLimit;
        command.vdwWeight = this.vdwWeight;
        return command;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        this.ps.println("Starting to optimize helices!");
        Properties properties = new Properties();
        if (this.objectBlocks == null) {
            throw new CommandExecutionException("No object blocks defined!");
        }
        if (this.objectBlocks.size() == 0) {
            throw new CommandExecutionException("Zero object blocks defined!");
        }
        try {
            this.ps.println("Repulsion term weight: " + this.electrostaticWeight);
            this.ps.println("Number of object blocks: " + this.objectBlocks.size());
            properties = this.controller.optimizeSystematic(this.electrostaticWeight, this.vdwWeight, this.objectBlocks, this.permutators, this.outputInterval);
        }
        catch (Object3DGraphControllerException gce) {
            throw new CommandExecutionException(gce.getMessage());
        }
        this.controller.refresh(new ModelChangeEvent((Object)this.controller, 4));
        this.ps.println("Helix optimization finished! Result:");
        this.ps.println(properties.toString());
        this.resultProperties = properties;
    }

    List<Object3DSet> parseObjectBlocks(String blocks) throws CommandExecutionException {
        ArrayList<Object3DSet> result = new ArrayList<Object3DSet>();
        String[] setWords = blocks.split(";");
        for (int i = 0; i < setWords.length; ++i) {
            String[] objWords = setWords[i].split(",");
            if (objWords.length < 1) {
                throw new CommandExecutionException("Error in optbasepairs: expected at least one object in " + setWords[i]);
            }
            SimpleObject3DSet set = new SimpleObject3DSet();
            for (int j = 0; j < objWords.length; ++j) {
                String objName = objWords[j];
                Object3D obj = this.controller.getGraph().findByFullName(objName);
                if (obj == null) {
                    throw new CommandExecutionException("Could not find object with name: " + objName);
                }
                set.add(obj);
            }
            result.add(set);
        }
        return result;
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private Vector3D parseVector(String s) throws CommandExecutionException {
        if (s == null || s.equals("")) {
            return null;
        }
        String[] words = s.split(",");
        if (words.length != 3) {
            throw new CommandExecutionException("Expected 3 words in vector descriptor: " + s);
        }
        Vector3D result = new Vector3D();
        try {
            result.setX(Double.parseDouble(words[0]));
            result.setY(Double.parseDouble(words[1]));
            result.setZ(Double.parseDouble(words[2]));
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Error parsing item of vector descriptor: " + s);
        }
        if (result.length() == 0.0) {
            throw new CommandExecutionException("Zero vector length found in vector descriptor: " + s);
        }
        return result;
    }

    private List<Vector3D> parseAxisList(String s) throws CommandExecutionException {
        String[] words = s.split(";");
        ArrayList<Vector3D> result = new ArrayList<Vector3D>();
        for (int i = 0; i < words.length; ++i) {
            result.add(this.parseVector(words[i]));
        }
        return result;
    }

    private IntegerPermutatorList parseSystematicMutators(String s) throws CommandExecutionException {
        String[] words;
        IntegerPermutatorList result = new IntegerPermutatorList();
        for (String word : words = s.split(";")) {
            result.add(this.parseSystematicMutator(word));
        }
        return result;
    }

    private SystematicMutator2 parseSystematicMutator(String s) throws CommandExecutionException {
        String[] words = s.split(",");
        if (words.length != 9 && words.length != 6) {
            throw new CommandExecutionException("Error parseing systematic mutator, expected 9 comma-separated items (minx,miny,minz,n,dx,na,axisx,axisy,axisz): " + s);
        }
        Vector3D minPos = new Vector3D();
        Vector3D axis = null;
        int n = 0;
        double dx = 1.0;
        int na = 0;
        try {
            minPos.setX(Double.parseDouble(words[0]));
            minPos.setY(Double.parseDouble(words[1]));
            minPos.setZ(Double.parseDouble(words[2]));
            n = Integer.parseInt(words[3]);
            if (n <= 0) {
                throw new CommandExecutionException("Number of grid elements must be greater zero: " + words[5]);
            }
            dx = Double.parseDouble(words[4]);
            if (dx <= 0.0) {
                throw new CommandExecutionException("Size of grid spacing must be greater zero: " + words[5]);
            }
            na = Integer.parseInt(words[5]);
            if (na <= 0) {
                throw new CommandExecutionException("Number of angle divisions must be greater zero: " + words[5]);
            }
            if (words.length >= 9 && (axis = new Vector3D(Double.parseDouble(words[6]), Double.parseDouble(words[7]), Double.parseDouble(words[8]))).length() == 0.0) {
                throw new CommandExecutionException("Rotation axis must have length greater zero: " + words[6] + " " + words[7] + " " + words[8]);
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Error parseing number in systematic mutator: " + s);
        }
        int[] maxNumbers = new int[]{n, n, n, na, axis == null ? na : 1};
        SystematicMutator2 result = null;
        result = axis == null ? new SystematicMutator2(dx, minPos, maxNumbers) : new SystematicMutator2(dx, minPos, maxNumbers, axis);
        return result;
    }

    private void prepareReadout() throws CommandExecutionException {
        Command importParameter = this.getParameter("helices");
        if (importParameter != null) {
            String value = ((StringParameter)importParameter).getValue().toLowerCase();
            if (value.equals("true")) {
                this.addHelicesFlag = true;
            } else if (value.equals("false")) {
                this.addHelicesFlag = false;
            } else {
                throw new CommandExecutionException(this.helpOutput());
            }
        }
        try {
            Command vdwParameter;
            Command tParameter;
            Command helixRootParameter;
            Command errorLimitParameter;
            Command repulsParameter = this.getParameter("repuls");
            if (repulsParameter != null) {
                this.electrostaticWeight = Double.parseDouble(((StringParameter)repulsParameter).getValue());
            }
            if ((errorLimitParameter = this.getParameter("error")) != null) {
                this.errorScoreLimit = Double.parseDouble(((StringParameter)errorLimitParameter).getValue());
            }
            if ((helixRootParameter = this.getParameter("helixroot")) != null) {
                this.helixRootName = ((StringParameter)helixRootParameter).getValue();
            }
            String movableParameterValue = "";
            if ((movableParameterValue = this.parse("blocks", movableParameterValue)) == null) {
                throw new CommandExecutionException("Option blocks=... has to be specified.");
            }
            this.objectBlocks = this.parseObjectBlocks(movableParameterValue);
            Command fixedParameter = this.getParameter("mut");
            if (fixedParameter != null) {
                this.permutators = this.parseSystematicMutators(((StringParameter)fixedParameter).getValue());
                assert (this.permutators != null);
                if (this.permutators.size() != this.objectBlocks.size()) {
                    throw new CommandExecutionException("Number of permutation descriptors has to be equal to number of blocks.");
                }
            }
            if ((tParameter = this.getParameter("t")) != null) {
                this.outputInterval = Integer.parseInt(((StringParameter)tParameter).getValue());
            }
            if ((vdwParameter = this.getParameter("vdw")) != null) {
                this.vdwWeight = Double.parseDouble(((StringParameter)vdwParameter).getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Bad number format detected: " + nfe.getMessage());
        }
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"optsystematic\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " [options]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Optimize distance and/or basepair constraints." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        helpText = helpText + "     blocks=name1[,name2[...]][;name3[,name4[...]]]] : defines object blocks";
        helpText = helpText + "     error=DOUBLE" + PackageConstants.NEWLINE + "          Set the error limit parameter." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     mut=x,y,z,n,dx,na[,ax,ay,zy][;...]   : constrain space (defined by minimum positions x,y,z, grid width dx, number of grid elements per dimension n, number of rotational steps na, rotation axis ax,ay,az." + PackageConstants.NEWLINE;
        helpText = helpText + "     repuls=DOUBLE : weight of residue repulsion term. Default: 0.0" + PackageConstants.NEWLINE;
        helpText = helpText + "     t=OUTPUTINTERVAL : status output at specified intervals. Default: 10000" + PackageConstants.NEWLINE;
        helpText = helpText + "     vdw=DOUBLE    : weight of Van de Waals term. Default: 0.0." + PackageConstants.NEWLINE;
        return helpText;
    }

    private String helpOutput() {
        return "Correct usage: optsystematic [blocks=name1[,name2[...]][;name3[,name4[...]]]] [error=value][fixed=a,b,c[;d,e,f[...]]][mut=x,y,z,n,dx,na[,ax,ay,zy][;...]][repuls=<value>][vdw=<value>][rms=<value>] [steps=<value>] [t=OUTPUTINTERVALL]";
    }
}

