/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import controltools.ModelChangeEvent;
import generaltools.ParsingException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnamodel.FitParameters;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.SimpleObject3DSet;

public class OptimizeHelicesCommand
extends AbstractCommand {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final String COMMAND_NAME = "opthelices";
    private boolean addHelicesFlag = true;
    private String helixRootName = "root";
    private boolean keepFirstFixed = true;
    private double kt = 30.0;
    private String movableNames = null;
    private String parentNames = null;
    private int connectionAlgorithm = 3;
    private int helixMutInterval = 0;
    private int numSteps = 100000;
    private int optimizerAlgorithm = 0;
    private double stemRmsLimit = 10.0;
    private double stemAngleLimit = Math.PI;
    private double errorScoreLimit = 0.1;
    private double errorScoreInitialLimit = 1.0E15;
    private int fuseStrandsMode = 0;
    private Object3DGraphController controller;
    private PrintStream ps;

    public OptimizeHelicesCommand(Object3DGraphController controller, PrintStream ps) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
        this.ps = ps;
    }

    @Override
    public Object cloneDeep() {
        OptimizeHelicesCommand command = new OptimizeHelicesCommand(this.controller, this.ps);
        command.addHelicesFlag = this.addHelicesFlag;
        command.helixRootName = this.helixRootName;
        command.keepFirstFixed = this.keepFirstFixed;
        command.kt = this.kt;
        command.movableNames = this.movableNames;
        command.parentNames = this.parentNames;
        command.connectionAlgorithm = this.connectionAlgorithm;
        command.numSteps = this.numSteps;
        command.optimizerAlgorithm = this.optimizerAlgorithm;
        command.stemRmsLimit = this.stemRmsLimit;
        command.stemAngleLimit = this.stemAngleLimit;
        command.errorScoreLimit = this.errorScoreLimit;
        command.errorScoreInitialLimit = this.errorScoreInitialLimit;
        command.fuseStrandsMode = this.fuseStrandsMode;
        return command;
    }

    private Object3DSet generateMovableObjects(String movableNames) throws CommandExecutionException {
        if (movableNames == null) {
            return null;
        }
        String[] words = movableNames.split(",");
        if (words == null || words.length == 0) {
            return null;
        }
        SimpleObject3DSet oset = new SimpleObject3DSet();
        for (int i = 0; i < words.length; ++i) {
            Object3D obj = this.controller.getGraph().findByFullName(words[i]);
            if (obj == null) {
                throw new CommandExecutionException("Could not find object: " + words[i]);
            }
            oset.add(obj);
        }
        return oset;
    }

    private Object3DSet generateParentObjects(String parentNames) throws CommandExecutionException {
        SimpleObject3DSet oset = new SimpleObject3DSet();
        if (parentNames == null) {
            log.info("Warning: no parent objects have been specified with the opthelices option parents=");
            return oset;
        }
        String[] words = parentNames.split(",");
        if (words == null || words.length == 0) {
            return null;
        }
        for (int i = 0; i < words.length; ++i) {
            Object3D obj = this.controller.getGraph().findByFullName(words[i]);
            if (obj == null) {
                throw new CommandExecutionException("Could not find object: " + words[i]);
            }
            oset.add(obj);
        }
        return oset;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        this.ps.println("Starting to optimize helices!");
        FitParameters stemFitParameters = null;
        Properties properties = new Properties();
        if (this.addHelicesFlag) {
            stemFitParameters = new FitParameters(this.stemRmsLimit, this.stemAngleLimit);
        }
        try {
            Object3DSet movableObjects = this.generateMovableObjects(this.movableNames);
            Object3DSet parentObjects = this.generateParentObjects(this.parentNames);
            if (movableObjects != null) {
                this.ps.println("Number of movable objects: " + movableObjects.size());
            } else {
                this.ps.println("All objects with constraints are considered movable.");
            }
            if (parentObjects != null) {
                this.ps.println("Number of parent objects that are moved as one block: " + parentObjects.size());
            } else {
                this.ps.println("No parent objects defined.");
            }
            this.ps.println("Starting controller.optimizeHelices!");
            properties = this.controller.optimizeHelices(this.numSteps, this.errorScoreLimit, this.errorScoreInitialLimit, this.kt, stemFitParameters, this.helixRootName, movableObjects, parentObjects, this.connectionAlgorithm, this.fuseStrandsMode, this.keepFirstFixed, this.helixMutInterval);
            this.ps.println("Finished controller.optimizeHelices!");
        }
        catch (Object3DGraphControllerException gce) {
            throw new CommandExecutionException(gce.getMessage());
        }
        this.controller.refresh(new ModelChangeEvent((Object)this.controller, 4));
        this.ps.println("Helix optimization finished! Result:");
        this.ps.println(properties.toString());
        this.resultProperties = properties;
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        Command importParameter = this.getParameter("helices");
        if (importParameter != null) {
            String value = ((StringParameter)importParameter).getValue().toLowerCase();
            if (value.equals("true")) {
                this.addHelicesFlag = true;
            } else if (value.equals("false")) {
                this.addHelicesFlag = false;
            } else {
                throw new CommandExecutionException(this.helpOutput());
            }
        }
        try {
            Command parentParameter;
            Command movableParameter;
            Command helixRootParameter;
            Command firstFixedParameter;
            Command errorLimitParameter2;
            Command fuseParameter;
            Command errorLimitParameter;
            Command helixIntervalParameter;
            Command stepsParameter;
            Command rmsParameter;
            Command ktParameter = this.getParameter("kt");
            if (ktParameter != null) {
                this.kt = Double.parseDouble(((StringParameter)ktParameter).getValue());
                log.finest("Parsing kt and setting to : " + this.kt);
            }
            if ((rmsParameter = this.getParameter("rms")) != null) {
                this.stemRmsLimit = Double.parseDouble(((StringParameter)rmsParameter).getValue());
            }
            if ((stepsParameter = this.getParameter("steps")) != null) {
                this.numSteps = Integer.parseInt(((StringParameter)stepsParameter).getValue());
            }
            if ((helixIntervalParameter = this.getParameter("bpinterval")) != null) {
                this.helixMutInterval = Integer.parseInt(((StringParameter)helixIntervalParameter).getValue());
            }
            if ((errorLimitParameter = this.getParameter("error")) != null) {
                this.errorScoreLimit = Double.parseDouble(((StringParameter)errorLimitParameter).getValue());
            }
            if ((fuseParameter = this.getParameter("fuse")) != null) {
                String s = ((StringParameter)fuseParameter).getValue();
                if (s.equals("false")) {
                    this.fuseStrandsMode = 0;
                } else if (s.equals("append")) {
                    this.fuseStrandsMode = 1;
                } else if (s.equals("prepend")) {
                    this.fuseStrandsMode = 2;
                } else {
                    throw new CommandExecutionException("Error parsing strand fuse mode (allowd: false|append|prepend):" + s);
                }
            }
            if ((errorLimitParameter2 = this.getParameter("initial-error")) != null) {
                this.errorScoreInitialLimit = Double.parseDouble(((StringParameter)errorLimitParameter2).getValue());
            }
            if ((firstFixedParameter = this.getParameter("firstfixed")) != null) {
                this.keepFirstFixed = ((StringParameter)firstFixedParameter).parseBoolean();
            }
            if ((helixRootParameter = this.getParameter("helixroot")) != null) {
                this.helixRootName = ((StringParameter)helixRootParameter).getValue();
            }
            if ((movableParameter = this.getParameter("movable")) != null) {
                this.movableNames = ((StringParameter)movableParameter).getValue();
            }
            if ((parentParameter = this.getParameter("parent")) == null) {
                parentParameter = this.getParameter("blocks");
            }
            if (parentParameter != null) {
                this.parentNames = ((StringParameter)parentParameter).getValue();
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Bad number format detected: " + nfe.getMessage());
        }
        catch (ParsingException pe) {
            throw new CommandExecutionException("Bad format detected: " + pe.getMessage());
        }
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"opthelices\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " [options]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Optimize sequences command TODO." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        helpText = helpText + "     blocks=name1,name2,..." + PackageConstants.NEWLINE + "        Defines which blocks are considered a group in the optimization. Alternative option name: parent" + PackageConstants.NEWLINE;
        helpText = helpText + "     helices=true|false" + PackageConstants.NEWLINE + "          if true, add helices after optimization" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     error=DOUBLE" + PackageConstants.NEWLINE + "          Set the error limit parameter." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     firstfixed=true|false    : iff true, keeps first block fixed during optimization (default:true)" + PackageConstants.NEWLINE;
        helpText = helpText + "     fuse=false|append|prepend" + PackageConstants.NEWLINE;
        helpText = helpText + "     bpinterval=INTEGER    : an integer that is greater or equal zero. If greater zero: every this many steps the helix lengths of the helix constrataints will be mutated." + PackageConstants.NEWLINE;
        helpText = helpText + "     kt=DOUBLE" + PackageConstants.NEWLINE + "           Sets the temperature tolerance parameter kt for simulated annealing." + PackageConstants.NEWLINE;
        helpText = helpText + "     movable=name1,name2,..." + PackageConstants.NEWLINE + "        Defines which blocks can be moved in the optimization." + PackageConstants.NEWLINE;
        helpText = helpText + "     parent=name1,name2,..." + PackageConstants.NEWLINE + "        Deprecated; use blocks=... option. Defines which blocks are considered a group in the optimization." + PackageConstants.NEWLINE;
        helpText = helpText + "     rms=DOUBLE" + PackageConstants.NEWLINE + "          TODO" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     import=true|false" + PackageConstants.NEWLINE + "          TODO" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     helixroot=name  : insert generated helices at subtree with this name" + PackageConstants.NEWLINE;
        helpText = helpText + "     steps=NUMBER    : number of optimization steps." + PackageConstants.NEWLINE;
        return helpText;
    }

    private String helpOutput() {
        return "Correct usage: opthelices [firstfixed=true|false][fuse=false|append|prepend][helices=true|false][bpinterval=value][kt=value][movable=name1,name2,...][block|parent=name1,name2,...][rms=<value>][steps=<value>]";
    }
}

