/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.BadSyntaxException;
import commandtools.CommandException;
import commandtools.CommandExecutionException;
import commandtools.UnknownCommandException;
import generaltools.StringTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import rnadesign.designapp.AbstractDesigner;
import rnadesign.designapp.HelpCommand;
import rnadesign.designapp.NanoTilerInterpreter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;

public class NanoTilerScripter
extends AbstractDesigner {
    public static Level logLevel = Level.FINE;
    public static final String PROMPT = "nano>";
    public static final int SUCCESS_CODE = 0;
    public static final int FAIL_CODE = 1;
    public static final String LOGFILE_DEFAULT = "nanotilerscripter";
    public static String nanotilerHome = System.getenv("NANOTILER_HOME");

    public NanoTilerScripter() {
        super(new Object3DGraphController(), new NanoTilerInterpreter(System.out, Logger.getLogger(LOGFILE_DEFAULT)));
        NanoTilerInterpreter interpreter = (NanoTilerInterpreter)this.getInterpreter();
        interpreter.setApplication(this);
        log.setLevel(logLevel);
    }

    public NanoTilerScripter(Object3DGraphController controller) {
        super(controller, new NanoTilerInterpreter(System.out, Logger.getLogger(LOGFILE_DEFAULT)));
        NanoTilerInterpreter interpreter = (NanoTilerInterpreter)this.getInterpreter();
        interpreter.setApplication(this);
        log.setLevel(logLevel);
    }

    private static void fail(int code) {
        System.exit(code);
    }

    private void printHelp(PrintStream ps) {
        HelpCommand helpCommand = new HelpCommand(System.out, (NanoTilerInterpreter)this.getInterpreter());
        ps.println(helpCommand.getMessage());
    }

    protected void runDefaultScript() throws CommandException, IOException {
        String defaultScriptName = nanotilerHome + PackageConstants.SLASH + "resources/defaults.script";
        File defaultScriptFile = new File(defaultScriptName);
        if (defaultScriptFile.exists()) {
            System.out.println("Running default script file: " + defaultScriptName);
            FileInputStream is = new FileInputStream(defaultScriptFile);
            this.runScript(is);
        } else {
            System.out.println("No default script found at " + defaultScriptName);
        }
    }

    public static void main(String[] args) {
        block20: {
            try {
                Object3DGraphController controller = new Object3DGraphController();
                NanoTilerScripter scripter = new NanoTilerScripter(controller);
                scripter.setUndoMode(false);
                if (args == null || args.length > 0 && args[0].equals("help")) {
                    scripter.printHelp(System.out);
                    System.exit(0);
                }
                if (nanotilerHome == null || nanotilerHome.equals("")) {
                    System.out.println("NANOTILER_HOME variable is not defined!");
                    System.exit(0);
                } else {
                    System.out.println("The NANOTILER_HOME variable is set to: " + nanotilerHome);
                }
                InputStream is = null;
                if (args.length > 1) {
                    for (int i = 1; i < args.length; ++i) {
                        String varName = "" + i;
                        System.out.println("Setting variable " + varName + " to " + args[i]);
                        scripter.getInterpreter().setVariable(varName, args[i]);
                    }
                }
                if (StringTools.indexOfString(args, "no-default") < 0) {
                    scripter.runDefaultScript();
                }
                if (args.length > 0) {
                    String scriptFileName = args[0];
                    System.out.println("Running script: " + scriptFileName);
                    is = new FileInputStream(scriptFileName);
                    scripter.runScript(is);
                    break block20;
                }
                System.out.println("Welcome to NanoTiler! (script mode)");
                scripter.printHelp(System.out);
                is = System.in;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                while (true) {
                    System.out.print(PROMPT);
                    try {
                        String line = reader.readLine();
                        if (line != null) {
                            scripter.runScriptLine(line);
                        }
                        break;
                    }
                    catch (CommandExecutionException ce) {
                        System.out.println("Command exception encountered: " + ce.getMessage());
                    }
                    catch (UnknownCommandException uce) {
                        System.out.println("Unknown command " + uce.getMessage());
                    }
                    catch (BadSyntaxException bse) {
                        System.out.println("Bad syntax : " + bse.getMessage());
                    }
                    catch (CommandException ce) {
                        System.out.println("Command exception: " + ce);
                    }
                }
            }
            catch (IOException ioe) {
                System.out.println("IO error reading file: " + args[0]);
                NanoTilerScripter.fail(1);
            }
            catch (CommandExecutionException ce) {
                System.out.println("Command exception encountered: " + ce.getMessage());
                NanoTilerScripter.fail(1);
            }
            catch (UnknownCommandException uce) {
                System.out.println("Error excecuting script: unknown command in " + args[0] + " : " + uce.getMessage());
                NanoTilerScripter.fail(1);
            }
            catch (BadSyntaxException bse) {
                System.out.println("Error excecuting script: bad syntax in " + args[0] + " : " + bse.getMessage());
                NanoTilerScripter.fail(1);
            }
            catch (CommandException ce) {
                System.out.println("Script command exception: " + ce);
                NanoTilerScripter.fail(1);
            }
        }
        System.out.println("Good bye!");
    }
}

