/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.CommandApplication;
import commandtools.DefineCommand;
import commandtools.EchoCommand;
import commandtools.EnvCommand;
import commandtools.ExitCommand;
import commandtools.ForeachCommand;
import commandtools.HistoryCommand;
import commandtools.Interpreter;
import commandtools.LineInterpreter;
import commandtools.NoOperationCommand;
import commandtools.QuitCommand;
import commandtools.SetCommand;
import commandtools.SourceCommand;
import java.io.PrintStream;
import java.util.logging.Logger;
import rnadesign.designapp.AbstractDesigner;
import rnadesign.designapp.AddAtomCommand;
import rnadesign.designapp.AddBasePairCommand;
import rnadesign.designapp.AlignCommand;
import rnadesign.designapp.AlignResiduesCommand;
import rnadesign.designapp.BridgeAllCommand;
import rnadesign.designapp.BridgeItCommand;
import rnadesign.designapp.CharacterizeCommand;
import rnadesign.designapp.CheckCommand;
import rnadesign.designapp.ChildrenCommand;
import rnadesign.designapp.ChosenCommand;
import rnadesign.designapp.ClearCommand;
import rnadesign.designapp.CloneCommand;
import rnadesign.designapp.ClosestCommand;
import rnadesign.designapp.ControllerCommand;
import rnadesign.designapp.DemoCommand;
import rnadesign.designapp.DeselectCommand;
import rnadesign.designapp.DistanceCommand;
import rnadesign.designapp.EndingCommand;
import rnadesign.designapp.ExportPdbCommand;
import rnadesign.designapp.ExportPdbSymCommand;
import rnadesign.designapp.ExtendCommand;
import rnadesign.designapp.FitCommand;
import rnadesign.designapp.FuseAllStrandsCommand;
import rnadesign.designapp.FuseStrandsCommand;
import rnadesign.designapp.GenJunctionCommand;
import rnadesign.designapp.GenLinkCommand;
import rnadesign.designapp.GenShapeCommand;
import rnadesign.designapp.GenerateDistanceConstraintCommand;
import rnadesign.designapp.GenerateHelixCommand;
import rnadesign.designapp.GenerateJunctionConstraintCommand;
import rnadesign.designapp.GenerateJunctionDBConstraintCommand;
import rnadesign.designapp.GenerateTorsionConstraintCommand;
import rnadesign.designapp.GrowCommand;
import rnadesign.designapp.GrowGraphCommand;
import rnadesign.designapp.HelixConstraintCommand;
import rnadesign.designapp.HelpCommand;
import rnadesign.designapp.ImportCommand;
import rnadesign.designapp.JBridgeItCommand;
import rnadesign.designapp.LinksCommand;
import rnadesign.designapp.LoadBasePairsCommand;
import rnadesign.designapp.LoadJunctionsCommand;
import rnadesign.designapp.LoadNucleotidesCommand;
import rnadesign.designapp.ManCommand;
import rnadesign.designapp.MissingLinkCommand;
import rnadesign.designapp.MoveCommand;
import rnadesign.designapp.MoveToClosestCommand;
import rnadesign.designapp.MutateCommand;
import rnadesign.designapp.OptimizeBasepairsCommand;
import rnadesign.designapp.OptimizeHelicesCommand;
import rnadesign.designapp.OptimizeRnaGraphCommand;
import rnadesign.designapp.OptimizeSystematicCommand;
import rnadesign.designapp.OrientCommand;
import rnadesign.designapp.PhysicsCommand;
import rnadesign.designapp.PlaceCommand;
import rnadesign.designapp.PropertiesCommand;
import rnadesign.designapp.RandomizeCommand;
import rnadesign.designapp.RemoveCommand;
import rnadesign.designapp.RemoveDupSequences;
import rnadesign.designapp.RemoveLinkCommand;
import rnadesign.designapp.RenameCommand;
import rnadesign.designapp.RenumberCommand;
import rnadesign.designapp.ResiduePropertyCommand;
import rnadesign.designapp.RingFixConstraintsCommand;
import rnadesign.designapp.RingFuseCommand;
import rnadesign.designapp.RotateCommand;
import rnadesign.designapp.ScoreFitCommand;
import rnadesign.designapp.SecondaryCommand;
import rnadesign.designapp.SeedCommand;
import rnadesign.designapp.SelectCommand;
import rnadesign.designapp.ShiftCommand;
import rnadesign.designapp.SignatureCommand;
import rnadesign.designapp.SplitStrandCommand;
import rnadesign.designapp.StatusCommand;
import rnadesign.designapp.StericCommand;
import rnadesign.designapp.SuperposableCommand;
import rnadesign.designapp.SymAddCommand;
import rnadesign.designapp.SymApplyCommand;
import rnadesign.designapp.SymInfoCommand;
import rnadesign.designapp.SynthCommand;
import rnadesign.designapp.TileCommand;
import rnadesign.designapp.TraceRnaGraphCommand;
import rnadesign.designapp.TraceRnaGraphScriptCommand;
import rnadesign.designapp.TreeCommand;
import rnadesign.designapp.TrimCommand;
import rnadesign.designapp.TwistCommand;
import rnadesign.designapp.UnShiftCommand;
import rnadesign.designapp.VerboseCommand;
import rnadesign.designapp.rnagui.GraphicsCommand;
import rnadesign.rnacontrol.Object3DGraphController;

public class NanoTilerInterpreter
extends LineInterpreter
implements Interpreter {
    private Object3DGraphController controller;
    private CommandApplication application;
    private static PrintStream ps;
    public static boolean developmentVersion;

    public NanoTilerInterpreter(PrintStream ps, Logger log) {
        super(log);
        NanoTilerInterpreter.ps = ps;
    }

    private void init() {
        this.clear();
        assert (this.application != null);
        if (developmentVersion) {
            this.addKnownCommand(new AddAtomCommand(this.controller));
            this.addKnownCommand(new AlignCommand(this.controller));
            this.addKnownCommand(new BridgeAllCommand(ps, this.controller));
            this.addKnownCommand(new BridgeItCommand(ps, this.controller));
            this.addKnownCommand(new JBridgeItCommand(ps, this.controller));
            this.addKnownCommand(new OptimizeRnaGraphCommand(this.controller, ps));
            this.addKnownCommand(new TraceRnaGraphCommand(this.controller, ps));
        }
        this.addKnownCommand(new AlignResiduesCommand(this.controller));
        this.addKnownCommand(new CharacterizeCommand(ps, this.controller));
        this.addKnownCommand(new ChildrenCommand(ps, this.controller));
        this.addKnownCommand(new ClearCommand(this.controller));
        this.addKnownCommand(new CloneCommand(this.controller));
        this.addKnownCommand(new ClosestCommand(ps, this.controller));
        this.addKnownCommand(new CheckCommand(ps, this.controller));
        this.addKnownCommand(new ChosenCommand(ps, this.controller));
        this.addKnownCommand(new ControllerCommand(this.controller));
        this.addKnownCommand(new DefineCommand(this.application));
        this.addKnownCommand(new DemoCommand(this.application));
        this.addKnownCommand(new DeselectCommand(ps, this.controller));
        this.addKnownCommand(new DistanceCommand(ps, this.controller));
        this.addKnownCommand(new EchoCommand());
        this.addKnownCommand(new EndingCommand(this.controller));
        this.addKnownCommand(new EnvCommand(this.getVariables(), ps));
        this.addKnownCommand(new ExitCommand());
        this.addKnownCommand(new ExportPdbCommand(this.controller));
        this.addKnownCommand(new ExportPdbSymCommand(this.controller));
        assert (this.getVariables() != null);
        this.addKnownCommand(new ExtendCommand(ps, this.controller));
        this.addKnownCommand(new FitCommand(ps, this.controller));
        this.addKnownCommand(new ForeachCommand(this.getVariables(), this.application));
        this.addKnownCommand(new FuseStrandsCommand(this.controller));
        this.addKnownCommand(new FuseAllStrandsCommand(this.controller));
        this.addKnownCommand(new AddBasePairCommand(this.controller));
        this.addKnownCommand(new GenLinkCommand(this.controller));
        this.addKnownCommand(new GenerateDistanceConstraintCommand(this.controller));
        this.addKnownCommand(new GenerateJunctionDBConstraintCommand(this.controller));
        this.addKnownCommand(new GenerateHelixCommand(this.controller));
        this.addKnownCommand(new GenJunctionCommand(this.controller));
        this.addKnownCommand(new HelixConstraintCommand(this.controller));
        this.addKnownCommand(new GenerateJunctionConstraintCommand(this.controller));
        this.addKnownCommand(new GenShapeCommand(this.controller));
        this.addKnownCommand(new GenerateTorsionConstraintCommand(this.controller));
        this.addKnownCommand(new GraphicsCommand(this.controller));
        this.addKnownCommand(new GrowCommand(this.controller));
        this.addKnownCommand(new GrowGraphCommand(this.controller));
        this.addKnownCommand(new HelpCommand(ps, this));
        this.addKnownCommand(new HistoryCommand(this.application));
        this.addKnownCommand(new ImportCommand(this.controller));
        this.addKnownCommand(new LinksCommand(ps, this.controller));
        this.addKnownCommand(new LoadBasePairsCommand(this.controller));
        this.addKnownCommand(new LoadJunctionsCommand(this.controller));
        this.addKnownCommand(new LoadNucleotidesCommand(this.controller));
        this.addKnownCommand(new ManCommand(ps, this));
        this.addKnownCommand(new MissingLinkCommand(ps, this.controller));
        this.addKnownCommand(new MoveCommand(this.controller));
        this.addKnownCommand(new MoveToClosestCommand(this.controller));
        this.addKnownCommand(new MutateCommand(this.controller));
        this.addKnownCommand(new NoOperationCommand());
        this.addKnownCommand(new OptimizeBasepairsCommand(this.controller, ps));
        this.addKnownCommand(new OptimizeHelicesCommand(this.controller, ps));
        this.addKnownCommand(new OptimizeSystematicCommand(this.controller, ps));
        this.addKnownCommand(new OrientCommand(this.controller));
        this.addKnownCommand(new PhysicsCommand(this.controller));
        this.addKnownCommand(new PlaceCommand(this.controller));
        this.addKnownCommand(new PropertiesCommand(this.controller));
        this.addKnownCommand(new QuitCommand());
        this.addKnownCommand(new RandomizeCommand(this.controller));
        this.addKnownCommand(new RemoveCommand(this.controller));
        this.addKnownCommand(new RemoveLinkCommand(this.controller));
        this.addKnownCommand(new RemoveDupSequences(this.controller));
        this.addKnownCommand(new RenameCommand(this.controller));
        this.addKnownCommand(new RenumberCommand(this.controller));
        this.addKnownCommand(new ResiduePropertyCommand(this.controller));
        this.addKnownCommand(new RingFixConstraintsCommand(this.controller));
        this.addKnownCommand(new RingFuseCommand(this.controller));
        this.addKnownCommand(new RotateCommand(this.controller));
        this.addKnownCommand(new ScoreFitCommand(ps, this.controller));
        this.addKnownCommand(new SecondaryCommand(ps, this.controller));
        this.addKnownCommand(new SeedCommand());
        this.addKnownCommand(new SelectCommand(this.controller));
        this.addKnownCommand(new SetCommand(this.getVariables()));
        this.addKnownCommand(new ShiftCommand(this.controller));
        this.addKnownCommand(new SignatureCommand(this.controller));
        this.addKnownCommand(new SourceCommand(this.application));
        this.addKnownCommand(new SplitStrandCommand(this.controller));
        this.addKnownCommand(new StatusCommand(ps, this.controller));
        this.addKnownCommand(new StericCommand(ps, this.controller));
        this.addKnownCommand(new SuperposableCommand(ps, this.controller));
        this.addKnownCommand(new SymAddCommand(this.controller));
        this.addKnownCommand(new SymApplyCommand(this.controller));
        this.addKnownCommand(new SymInfoCommand(ps, this.controller));
        this.addKnownCommand(new SynthCommand(this.controller));
        this.addKnownCommand(new TileCommand(this.controller));
        this.addKnownCommand(new TraceRnaGraphScriptCommand(this.controller));
        this.addKnownCommand(new TreeCommand(ps, this.controller));
        this.addKnownCommand(new TrimCommand(this.controller));
        this.addKnownCommand(new TwistCommand(this.controller));
        this.addKnownCommand(new UnShiftCommand(this.controller));
        this.addKnownCommand(new VerboseCommand());
    }

    public void setApplication(AbstractDesigner app) {
        this.application = app;
        this.controller = app.getGraphController();
        this.init();
    }

    static {
        developmentVersion = true;
    }
}

