/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class LoadNucleotidesCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "loadnucleotides";
    private String fileName;
    private Object3DGraphController controller;

    public LoadNucleotidesCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        LoadNucleotidesCommand command = new LoadNucleotidesCommand(this.controller);
        command.fileName = this.fileName;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    private String helpOutput() {
        return "Correct usage: loadnucleotides filename";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"loadnucleotides\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " FILENAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     LoadNucleotides command TODO." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        if (this.fileName == null || this.fileName.length() == 0) {
            throw new CommandExecutionException(this.helpOutput());
        }
        try {
            this.controller.readNucleotideDB(this.fileName);
        }
        catch (Object3DGraphControllerException oce) {
            throw new CommandExecutionException(oce.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() == 0) {
            throw new CommandExecutionException(this.helpOutput());
        }
        assert (this.getParameterCount() > 0);
        assert (this.getParameter(0) instanceof StringParameter);
        StringParameter stringParameter = (StringParameter)this.getParameter(0);
        this.fileName = stringParameter.getValue();
    }
}

