/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.IntParameter;
import commandtools.StringParameter;
import java.io.File;
import java.util.logging.Logger;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.PdbJunctionControllerParameters;
import rnadesign.rnamodel.CorridorDescriptor;

public class LoadJunctionsCommand
extends AbstractCommand {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final String COMMAND_NAME = "loadjunctions";
    private int orderMax = 5;
    private int stemLengthMin = 3;
    private String fileName;
    private String usedDirectory;
    private int loopLengthSumMax = 50;
    private String writeName;
    private String writeDir;
    private boolean noWriteFlag = false;
    private boolean intHelixCheck = true;
    boolean rnaMode = true;
    int branchDescriptorOffset = 2;
    private CorridorDescriptor corridorDescriptor = new CorridorDescriptor(0.0, 2.0);
    private Object3DGraphController controller;

    public LoadJunctionsCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        LoadJunctionsCommand command = new LoadJunctionsCommand(this.controller);
        command.orderMax = this.orderMax;
        command.fileName = this.fileName;
        command.usedDirectory = this.usedDirectory;
        command.writeName = this.writeName;
        command.writeDir = this.writeDir;
        command.noWriteFlag = this.noWriteFlag;
        command.rnaMode = this.rnaMode;
        command.branchDescriptorOffset = this.branchDescriptorOffset;
        command.stemLengthMin = this.stemLengthMin;
        command.corridorDescriptor = new CorridorDescriptor(this.corridorDescriptor);
        command.intHelixCheck = this.intHelixCheck;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        log.info("Starting to read junctions using a minimum stem-length cutoff of " + this.stemLengthMin);
        PdbJunctionControllerParameters prm = new PdbJunctionControllerParameters(this.orderMax, this.fileName, this.usedDirectory, this.writeDir, this.noWriteFlag, this.rnaMode, this.branchDescriptorOffset, this.stemLengthMin, this.corridorDescriptor, this.loopLengthSumMax, this.intHelixCheck);
        assert (prm != null);
        this.controller.resetJunctionController(prm);
        this.controller.setLastReadDirectory(this.usedDirectory);
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() == 0) {
            throw new CommandExecutionException(this.helpOutput());
        }
        assert (this.getParameterCount() > 0);
        assert (this.getParameter(0) instanceof StringParameter);
        StringParameter stringParameter = (StringParameter)this.getParameter(0);
        this.fileName = stringParameter.getValue();
        log.fine("Nanotiler should write something here. LoadJunctionsCommand line 72");
        if (this.getParameterCount() > 1) {
            assert (this.getParameter(1) instanceof StringParameter);
            StringParameter stringParameter2 = (StringParameter)this.getParameter(1);
            this.usedDirectory = stringParameter2.getValue();
        } else {
            this.usedDirectory = new File(this.fileName).getParent();
        }
        try {
            StringParameter intHelixCheckParameter;
            StringParameter corridorWidthParameter;
            StringParameter stemMinParameter;
            if (this.getParameterCount() > 2) {
                Command parameter3 = this.getParameter(2);
                if (parameter3 instanceof StringParameter) {
                    this.branchDescriptorOffset = Integer.parseInt(((StringParameter)parameter3).getValue());
                } else if (parameter3 instanceof IntParameter) {
                    this.branchDescriptorOffset = ((IntParameter)parameter3).getValue();
                }
            }
            if ((stemMinParameter = (StringParameter)this.getParameter("stem-min")) != null) {
                this.stemLengthMin = Integer.parseInt(stemMinParameter.getValue());
            }
            if ((corridorWidthParameter = (StringParameter)this.getParameter("corridor-width")) != null) {
                double corridorWidth = Double.parseDouble(corridorWidthParameter.getValue());
                this.corridorDescriptor = new CorridorDescriptor(corridorWidth, 2.0);
            }
            if ((intHelixCheckParameter = (StringParameter)this.getParameter("inthelixcheck")) != null) {
                this.intHelixCheck = Boolean.parseBoolean(intHelixCheckParameter.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Error parsing value: " + nfe.getMessage());
        }
    }

    public String helpOutput() {
        return "Correct usage: loadjunctions fileName [directory [offset]][stem-min=1|2|3|4|...][corridor-width=DOUBLE][inthelixcheck=BOOLEAN]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"loadjunctions\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " [options]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     LoadJunctions command TODO.";
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        helpText = helpText + "     stringparameter  : name of file with relative filenames of junctions" + PackageConstants.NEWLINE;
        helpText = helpText + "     stringparameter2 : name of directory of junctions" + PackageConstants.NEWLINE;
        helpText = helpText + "     branchDescriptorOffset : 0|1|2|... : Length of connector helices. Default: 2. Often used: 3" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     stem-min=1|2|3|...    : Minimum length of considered stems." + PackageConstants.NEWLINE;
        helpText = helpText + "     corridor-width=DOUBLE : Sets the radius of the corridor in front of helices in which collisions will be checked for. Default: 0. Often used: 3." + PackageConstants.NEWLINE;
        helpText = helpText + "     inthelixcheck=BOOLEAN : Indicates whether or not the program should check for internal helices in the parsed pdb files. Default: True." + PackageConstants.NEWLINE;
        return helpText;
    }
}

