/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.io.FileInputStream;
import java.io.IOException;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;

public class LoadBasePairsCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "loadbasepairs";
    private String fileName;
    private Object3DGraphController controller;

    public LoadBasePairsCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        LoadBasePairsCommand command = new LoadBasePairsCommand(this.controller);
        command.fileName = this.fileName;
        command.controller = this.controller;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    private String helpOutput() {
        return "Correct usage: loadbasepairs filename";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"loadbasepairs\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " FILENAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     LoadBasePairs command TODO." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        if (this.fileName == null || this.fileName.length() == 0) {
            throw new CommandExecutionException(this.helpOutput());
        }
        try {
            FileInputStream fis = new FileInputStream(this.fileName);
            this.controller.getBasePairDB().read(fis);
        }
        catch (IOException ioe) {
            throw new CommandExecutionException("Error reading base pair file: " + ioe.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() == 0) {
            throw new CommandExecutionException(this.helpOutput());
        }
        assert (this.getParameterCount() > 0);
        assert (this.getParameter(0) instanceof StringParameter);
        StringParameter stringParameter = (StringParameter)this.getParameter(0);
        this.fileName = stringParameter.getValue();
    }
}

