/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.util.ArrayList;
import java.util.List;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnamodel.DBElementConnectionDescriptor;
import rnadesign.rnamodel.DBElementDescriptor;
import rnadesign.rnamodel.GrowConnectivity;
import tools3d.Vector3D;

public class GrowLoopCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "growloop";
    private Object3DGraphController controller;
    private List<DBElementDescriptor> blockList = new ArrayList<DBElementDescriptor>();
    private List<DBElementConnectionDescriptor> connections = new ArrayList<DBElementConnectionDescriptor>();
    private String rootName = "root";
    private String nameBase = "g_";
    private Vector3D startPosition = new Vector3D(0.0, 0.0, 0.0);
    private int generationCount = 1;
    private double stemRmsLimit = 10.0;
    private boolean addHelicesFlag = false;
    private boolean avoidCollisionsFlag = false;

    public GrowLoopCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    private List<DBElementDescriptor> cloneBlockList() {
        ArrayList<DBElementDescriptor> result = new ArrayList<DBElementDescriptor>();
        for (int i = 0; i < this.blockList.size(); ++i) {
            result.add((DBElementDescriptor)this.blockList.get(i).clone());
        }
        return result;
    }

    private List<DBElementConnectionDescriptor> cloneConnections() {
        ArrayList<DBElementConnectionDescriptor> result = new ArrayList<DBElementConnectionDescriptor>();
        for (int i = 0; i < this.connections.size(); ++i) {
            result.add((DBElementConnectionDescriptor)this.connections.get(i).clone());
        }
        return result;
    }

    @Override
    public Object cloneDeep() {
        GrowLoopCommand command = new GrowLoopCommand(this.controller);
        command.blockList = this.cloneBlockList();
        command.connections = this.cloneConnections();
        command.rootName = new String(this.rootName);
        command.nameBase = new String(this.nameBase);
        command.startPosition = this.startPosition;
        command.generationCount = this.generationCount;
        command.addHelicesFlag = this.addHelicesFlag;
        command.avoidCollisionsFlag = this.avoidCollisionsFlag;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: growloop block=j|k,order,index[;j|k,order,index] connect=1.1,1.2,3;1.3,2.1,4 [pos=x,y,z] [gen=number][steric=true|false] [helices=true|false]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"growloop\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " junction newparentname newname order id x y z [strand-ending]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     places specified junction at certain position in space." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            GrowConnectivity connectivity = new GrowConnectivity(this.blockList, this.connections, null, this.generationCount);
            connectivity.setNumGenerations(this.generationCount);
            this.controller.growBuildingBlocks(connectivity, this.rootName, this.nameBase, this.startPosition, this.addHelicesFlag, this.stemRmsLimit, this.avoidCollisionsFlag, 10.0, "found_ring");
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void readoutBlock(String block, int descriptorId) throws CommandExecutionException {
        if (block == null || block.length() == 0) {
            throw new CommandExecutionException("Error parsing building blocks option. Insufficient block description.");
        }
        String[] words = block.split(",");
        if (words.length != 3) {
            throw new CommandExecutionException("Error parsing building block: 4 elements expected for each block descriptor.");
        }
        int blockType = 0;
        int id = 0;
        int order = 0;
        if (words[0].equals("j")) {
            blockType = 1;
        } else if (words[0].equals("k")) {
            blockType = 2;
        } else {
            throw new CommandExecutionException("Unknown building block type: " + words[0]);
        }
        try {
            order = Integer.parseInt(words[1]);
            id = Integer.parseInt(words[2]) - 1;
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Grow command: Error parsing number: " + nfe.getMessage());
        }
        DBElementDescriptor element = new DBElementDescriptor(order, id, blockType, descriptorId);
        this.blockList.add(element);
    }

    private void readoutBlocks(String blocks) throws CommandExecutionException {
        if (blocks == null || blocks.length() == 0) {
            throw new CommandExecutionException("Error parsing building blocks option.");
        }
        String[] words = blocks.split(";");
        for (int i = 0; i < words.length; ++i) {
            this.readoutBlock(words[i], i);
        }
    }

    private void readoutConnection(String connection) throws CommandExecutionException {
        assert (connection != null);
        String[] words = connection.split(",");
        if (words.length != 5) {
            throw new CommandExecutionException("5 elements expected in connect descriptor");
        }
        try {
            int id1 = Integer.parseInt(words[0]) - 1;
            int id2 = Integer.parseInt(words[1]) - 1;
            String helixendName1 = words[2];
            String helixendName2 = words[3];
            DBElementDescriptor descriptor1 = this.blockList.get(id1);
            DBElementDescriptor descriptor2 = this.blockList.get(id2);
            int basePairCount = Integer.parseInt(words[4]);
            this.connections.add(new DBElementConnectionDescriptor(descriptor1, descriptor2, helixendName1, helixendName2, basePairCount));
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Number format exception while parsing connect option in grow command: " + nfe.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException oobe) {
            throw new CommandExecutionException("Index of out bounds exception while parsing connect option in grow command: " + oobe.getMessage());
        }
    }

    private void readoutConnections(String connections) throws CommandExecutionException {
        if (connections == null || connections.length() == 0) {
            throw new CommandExecutionException("Error parsing building blocks option.");
        }
        String[] words = connections.split(";");
        for (int i = 0; i < words.length; ++i) {
            this.readoutConnection(words[i]);
        }
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter hName;
        StringParameter pName;
        if (this.getParameterCount() == 0) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter pBlocks = (StringParameter)this.getParameter("blocks");
        if (pBlocks == null) {
            throw new CommandExecutionException("Building blocks have to be specified using the blocks option.");
        }
        this.readoutBlocks(pBlocks.getValue());
        StringParameter pConnect = (StringParameter)this.getParameter("connect");
        if (pConnect == null) {
            throw new CommandExecutionException("Building block connections have to be specified using the connect option.");
        }
        this.readoutConnections(pConnect.getValue());
        StringParameter pRoot = (StringParameter)this.getParameter("root");
        if (pRoot != null) {
            this.rootName = pRoot.getValue();
        }
        if ((pName = (StringParameter)this.getParameter("name")) != null) {
            this.nameBase = pName.getValue();
        }
        if ((hName = (StringParameter)this.getParameter("helices")) != null) {
            if ("true".equals(hName.getValue())) {
                this.addHelicesFlag = true;
            } else if ("false".equals(hName.getValue())) {
                this.addHelicesFlag = false;
            } else {
                throw new CommandExecutionException("helices option has values of either true of false");
            }
        }
        if ((hName = (StringParameter)this.getParameter("steric")) != null) {
            if ("true".equals(hName.getValue())) {
                this.avoidCollisionsFlag = true;
            } else if ("false".equals(hName.getValue())) {
                this.avoidCollisionsFlag = false;
            } else {
                throw new CommandExecutionException("steric option has values of either true of false");
            }
        }
        try {
            StringParameter genName = (StringParameter)this.getParameter("gen");
            if (genName != null) {
                this.generationCount = Integer.parseInt(genName.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Number format exception while parsing number of base pairs (option bp): " + nfe.getMessage());
        }
    }
}

