/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.util.ArrayList;
import java.util.List;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import tools3d.objects3d.MultiConstraintLink;

public class GenerateJunctionConstraintCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "genjunctionconstraint";
    private Object3DGraphController controller;
    private List<String> fivePrimeNames = new ArrayList<String>();
    private List<String> threePrimeNames = new ArrayList<String>();
    private double min = 4.0;
    private double max = 12.0;
    private String name = "jlink";
    private double minBridgable = 2.3;
    private double maxBridgable = 1.0E30;
    private List<Integer> symIds;

    public GenerateJunctionConstraintCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        GenerateJunctionConstraintCommand command = new GenerateJunctionConstraintCommand(this.controller);
        command.fivePrimeNames = this.fivePrimeNames;
        command.threePrimeNames = this.threePrimeNames;
        command.min = this.min;
        command.max = this.max;
        command.name = this.name;
        command.symIds = this.symIds;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: genjunctionconstraint ends=res1-5,res1-3,res2-5,res2-3[,res3-5,res3-3] min=distmin max=distmax [sym=ID1,ID2,...,IDN]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"genjunctionconstraint\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " ends=res1-5,res1-3,res2-5,res2-3[,res3-5,res3-3] min=DISTMIN max=DISTMAX minb=DISTMIN maxb=DISTMAX name=NAME [sym=ID1,ID2,...,IDN]";
        helpText = helpText + "Generates a junction-constraint by specifying alternating 5' and 3' residues of helix ends pointing towards a junction";
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            MultiConstraintLink newLink = this.controller.addJunctionMultiConstraintLink(this.name, this.fivePrimeNames, this.threePrimeNames, this.min, this.max, this.minBridgable, this.maxBridgable, this.symIds);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void parseEndResidues(String s) throws CommandExecutionException {
        String[] words = s.split(",");
        this.fivePrimeNames.clear();
        this.threePrimeNames.clear();
        if (words.length == 0 || words.length % 2 != 0) {
            throw new CommandExecutionException("Even number of residue descriptors expected (alternating 5' and 3' residue descriptors): " + s);
        }
        int i = 0;
        while (i + 1 < words.length) {
            this.fivePrimeNames.add(words[i]);
            this.threePrimeNames.add(words[i + 1]);
            i += 2;
        }
    }

    private void parseSymIds(String s) throws CommandExecutionException {
        String[] words = s.split(",");
        this.symIds = new ArrayList<Integer>();
        for (int i = 0; i < words.length; ++i) {
            this.symIds.add(Integer.parseInt(words[i]));
        }
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter pName;
        StringParameter pEnd = (StringParameter)this.getParameter("ends");
        if (pEnd == null) {
            throw new CommandExecutionException(this.helpOutput());
        }
        this.parseEndResidues(pEnd.getValue());
        StringParameter pSym = (StringParameter)this.getParameter("sym");
        if (pSym != null) {
            this.parseSymIds(pSym.getValue());
        }
        if ((pName = (StringParameter)this.getParameter("name")) != null) {
            this.name = pName.getValue();
        }
        try {
            StringParameter pMaxB;
            StringParameter pMinB;
            StringParameter pMax;
            StringParameter pMin = (StringParameter)this.getParameter("min");
            if (pMin != null) {
                this.min = Double.parseDouble(pMin.getValue());
            }
            if ((pMax = (StringParameter)this.getParameter("max")) != null) {
                this.max = Double.parseDouble(pMax.getValue());
            }
            if ((pMinB = (StringParameter)this.getParameter("minb")) != null) {
                this.minBridgable = Double.parseDouble(pMinB.getValue());
            }
            if ((pMaxB = (StringParameter)this.getParameter("maxb")) != null) {
                this.maxBridgable = Double.parseDouble(pMaxB.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Error parsing number value: " + nfe.getMessage());
        }
    }
}

