/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.PropertyTools;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class GenJunctionCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "genjunction";
    private Object3DGraphController controller;
    private String origName;
    private int angleDiv = 120;
    private String rootName;
    private double offset = 15.0;
    private double distMin = 3.0;
    private double distMax = 9.0;

    public GenJunctionCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        GenJunctionCommand command = new GenJunctionCommand(this.controller);
        command.origName = this.origName;
        command.angleDiv = this.angleDiv;
        command.rootName = this.rootName;
        command.offset = this.offset;
        command.distMin = this.distMin;
        command.distMax = this.distMax;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: genjunction CORNERNAME [ROOTNAME] [offset=VALUE][max=VALUE][min=VALUE][n=VALUE]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"genjunction\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " ORIGINALNAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "max=VALUE       maximum distance between connected 3' and 5' ends of helicas strands. Default: " + this.distMax + PackageConstants.NEWLINE;
        helpText = helpText + "min=VALUE       minimum distance between connected 3' and 5' ends of helicas strands. Default:" + this.distMin + PackageConstants.NEWLINE;
        helpText = helpText + "n=VALUE         Number of angles steps to explore full circe. Default: 120 (corresponds to 360/120=3 degrees)." + PackageConstants.NEWLINE;
        helpText = helpText + "offset=VALUE    distance from helices to curner point (in Angstroem). Default: " + this.offset + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Generates 3D junction for a graph corner" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            this.resultProperties = this.controller.generateJunction(this.origName, this.rootName, this.offset, this.distMin, this.distMax, this.angleDiv);
            PropertyTools.printProperties(System.out, this.resultProperties);
        }
        catch (Object3DGraphControllerException e) {
            System.out.println("Command error: " + e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() < 1) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        this.origName = p0.getValue();
        try {
            StringParameter poff = (StringParameter)this.getParameter("offset");
            if (poff != null) {
                this.offset = Double.parseDouble(poff.getValue());
            }
            if ((poff = (StringParameter)this.getParameter("max")) != null) {
                this.distMax = Double.parseDouble(poff.getValue());
            }
            if ((poff = (StringParameter)this.getParameter("min")) != null) {
                this.distMin = Double.parseDouble(poff.getValue());
            }
            if ((poff = (StringParameter)this.getParameter("n")) != null) {
                this.angleDiv = Integer.parseInt(poff.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Error parsing offset value: " + nfe.getMessage());
        }
    }
}

