/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.ParsingException;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.FittingException;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DTools;

public class FitCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "fit";
    private PrintStream ps;
    private Object3DGraphController controller;
    private boolean placeMode = true;
    private String mode;
    private String root = null;
    private String b1Name;
    private String b2Name;
    private double rms = 5.0;
    private int n1Min = 0;
    private int n1Max = 10;
    private int n2Min = 0;
    private int n2Max = 10;

    public FitCommand(PrintStream ps, Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
        this.ps = ps;
    }

    @Override
    public Object cloneDeep() {
        FitCommand command = new FitCommand(this.ps, this.controller);
        command.name = this.name;
        command.placeMode = this.placeMode;
        command.mode = this.mode;
        command.root = this.root;
        command.b1Name = this.b1Name;
        command.b2Name = this.b2Name;
        command.rms = this.rms;
        command.n1Min = this.n1Min;
        command.n1Max = this.n1Max;
        command.n2Min = this.n2Min;
        command.n2Max = this.n2Max;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: fit (j|k) branchdescriporName1 branchdescriptorName2 [place=true|false][h1min=val][h1max=val][h2min=val][h2max=val][rms=val]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"fit\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.helpOutput() + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Rank orders 2-way junctions into gap." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    private void printEntry(PrintStream ps, Properties result) {
        ps.println("" + result);
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        Object3D obj1 = this.controller.getGraph().findByFullName(this.b1Name);
        Object3D obj2 = this.controller.getGraph().findByFullName(this.b2Name);
        if (obj1 == null) {
            throw new CommandExecutionException("Could not find object 1 : " + this.b1Name);
        }
        if (obj2 == null) {
            throw new CommandExecutionException("Could not find object 2 : " + this.b2Name);
        }
        if (!(obj1 instanceof BranchDescriptor3D)) {
            throw new CommandExecutionException("Object 1 is not of type BranchDescriptor3D : " + this.b1Name);
        }
        if (!(obj2 instanceof BranchDescriptor3D)) {
            throw new CommandExecutionException("Object 2 is not of type BranchDescriptor3D : " + this.b2Name);
        }
        if (this.mode == null) {
            throw new CommandExecutionException("Undfined fit mode! Allowed: (j|k)");
        }
        BranchDescriptor3D b1 = (BranchDescriptor3D)obj1;
        BranchDescriptor3D b2 = (BranchDescriptor3D)obj2;
        List<Properties> result = null;
        double placeRms = this.rms;
        if (!this.placeMode) {
            placeRms = -this.rms;
        }
        if (this.root == null) {
            this.root = Object3DTools.findRoot(b1).getFullName();
        }
        try {
            if (this.mode.equals("j")) {
                result = this.controller.rankJunctionFits(b1, b2, this.n1Min, this.n1Max, this.n2Min, this.n2Max, placeRms, this.root);
            } else if (this.mode.equals("k")) {
                result = this.controller.rankKissingLoopFits(b1, b2, this.n1Min, this.n1Max, this.n2Min, this.n2Max, placeRms, this.root);
            } else {
                throw new CommandExecutionException("Unknown fit mode! Allowed: (j|k)");
            }
            if (result == null) {
                throw new CommandExecutionException("No fitting structural elements found!");
            }
        }
        catch (Object3DGraphControllerException ogce) {
            throw new CommandExecutionException(ogce.getMessage());
        }
        catch (FittingException fe) {
            throw new CommandExecutionException(fe.getMessage());
        }
        for (int i = 0; i < result.size(); ++i) {
            this.printEntry(this.ps, result.get(i));
            this.ps.println();
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() < 3) {
            throw new CommandExecutionException(this.helpOutput());
        }
        this.mode = ((StringParameter)this.getParameter(0)).getValue();
        this.b1Name = ((StringParameter)this.getParameter(1)).getValue();
        this.b2Name = ((StringParameter)this.getParameter(2)).getValue();
        try {
            this.placeMode = this.parse("place", this.placeMode);
            this.rms = this.parse("rms", this.rms);
            this.n1Min = this.parse("h1min", this.n1Min);
            this.n1Max = this.parse("h1min", this.n1Max - 1) + 1;
            this.n2Min = this.parse("h2min", this.n2Min);
            this.n2Max = this.parse("h2max", this.n2Max - 1) + 1;
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException(nfe.getMessage());
        }
        catch (ParsingException pe) {
            throw new CommandExecutionException(pe.getMessage());
        }
        StringParameter rootParam = (StringParameter)this.getParameter("root");
        if (rootParam != null) {
            this.root = rootParam.getValue();
        }
    }
}

