/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class ExportPdbSymCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "exportpdbsym";
    private String fileName;
    private Object3DGraphController controller;

    public ExportPdbSymCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        ExportPdbSymCommand command = new ExportPdbSymCommand(this.controller);
        command.fileName = this.fileName;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        try {
            this.controller.writePdbSymmetric(this.fileName);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException("Generating PDB file including symmetries: " + e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() {
        assert (this.getParameterCount() > 0);
        assert (this.getParameter(0) instanceof StringParameter);
        StringParameter stringParameter = (StringParameter)this.getParameter(0);
        this.fileName = stringParameter.getValue();
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"exportpdbsym\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " FILENAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     ExportPdbSym command TODO." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    private String helpOutput() {
        return "Correct usage: exportpdbsym FILENAME";
    }
}

