/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandApplication;
import commandtools.CommandException;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.io.File;
import java.io.FilenameFilter;
import rnadesign.designapp.PackageConstants;

public class DemoCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "demo";
    private String fileName;
    private CommandApplication application;
    private File[] files;

    public DemoCommand(CommandApplication application) {
        super(COMMAND_NAME);
        this.application = application;
    }

    @Override
    public Object cloneDeep() {
        DemoCommand command = new DemoCommand(this.application);
        command.fileName = this.fileName;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    public String helpOutput() {
        return "Reads and executes demo scripts available in ${NANOTILER_HOME}/demo/scripts. Correct usage: demo relativefilename";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"demo\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " FILENAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Demo command reads and executes script file located in ${NANOTILER_HOME}/demo/scripts." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.application != null);
        this.prepareReadout();
        if (this.fileName == null) {
            assert (this.files != null);
            System.out.println("Available demos: ");
            for (File file : this.files) {
                String name = file.getName();
                if (name.endsWith(".script")) {
                    System.out.println(name.substring(0, name.length() - 7));
                    continue;
                }
                System.out.println(name);
            }
            System.out.println("Run individual demo with command : demo NAME");
            System.out.println("Run all demos with command : demo all");
        } else if (this.fileName.equals("all")) {
            System.out.println("demo all not yet implemented!");
            for (File file : this.files) {
                try {
                    this.application.runScriptLine("echo #############################################################################");
                    this.application.runScriptLine("echo Running all available demos!");
                    this.application.runScriptLine("clear all");
                    String scriptName = PackageConstants.NANOTILER_HOME + "/demo/scripts/" + file.getName();
                    String command = "source " + scriptName;
                    this.application.runScriptLine("echo Executing demo script with command: " + command);
                    this.application.runScriptLine("echo #############################################################################");
                    this.application.runScriptLine(command);
                    this.application.runScriptLine("echo #############################################################################");
                    this.application.runScriptLine("echo Finished running all demos !");
                    this.application.runScriptLine("echo #############################################################################");
                }
                catch (CommandException ce) {
                    throw new CommandExecutionException(ce.getMessage());
                }
            }
        } else {
            if (!this.fileName.endsWith(".script")) {
                this.fileName = this.fileName + ".script";
            }
            try {
                String command = "source " + PackageConstants.NANOTILER_HOME + "/demo/scripts/" + this.fileName;
                this.application.runScriptLine("echo #############################################################################");
                this.application.runScriptLine("echo Running demo " + this.fileName);
                this.application.runScriptLine("echo Executing demo script with command: " + command);
                this.application.runScriptLine("echo #############################################################################");
                this.application.runScriptLine("clear all");
                this.application.runScriptLine(command);
                this.application.runScriptLine("echo #############################################################################");
                this.application.runScriptLine("echo Finished demo " + this.fileName);
                this.application.runScriptLine("echo #############################################################################");
            }
            catch (CommandException ce) {
                throw new CommandExecutionException(ce.getMessage());
            }
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        String dirName = PackageConstants.NANOTILER_HOME + PackageConstants.SLASH + COMMAND_NAME + PackageConstants.SLASH + "scripts";
        File dirFile = new File(dirName);
        if (!dirFile.exists()) {
            throw new CommandExecutionException("Could not find directory: " + dirName);
        }
        this.files = dirFile.listFiles(new ScriptNameFilter());
        if (this.getParameterCount() < 1) {
            return;
        }
        assert (this.getParameter(0) instanceof StringParameter);
        StringParameter stringParameter = (StringParameter)this.getParameter(0);
        this.fileName = stringParameter.getValue();
    }

    private class ScriptNameFilter
    implements FilenameFilter {
        private ScriptNameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name != null && name.endsWith(".script");
        }
    }
}

