/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class CloneCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "clone";
    private Object3DGraphController controller;
    private String origName;
    private String newParentName;
    private String newIndividualName;
    private int symId = 0;

    public CloneCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        CloneCommand command = new CloneCommand(this.controller);
        command.origName = this.origName;
        command.newParentName = this.newParentName;
        command.newIndividualName = this.newIndividualName;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: clone originalname newparentname newindividualname";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"clone\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " ORIGINALNAME NEWPARENTNAME NEWINDIVIDUALNAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Clone command clones an object to a new name and place." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            this.controller.cloneObject(this.origName, this.newParentName, this.newIndividualName, this.symId);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() < 3) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        this.origName = p0.getValue();
        StringParameter p1 = (StringParameter)this.getParameter(1);
        this.newParentName = p1.getValue();
        StringParameter p2 = (StringParameter)this.getParameter(2);
        this.newIndividualName = p2.getValue();
        StringParameter sp = (StringParameter)this.getParameter("sym");
        try {
            if (sp != null) {
                this.symId = Integer.parseInt(sp.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException(nfe.getMessage());
        }
    }
}

