/*
 * Decompiled with CFR 0.152.
 */
package launchtools;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Logger;
import launchtools.Job;
import launchtools.ProcessRunInfo;
import launchtools.Queue;
import launchtools.QueuePolicy;
import launchtools.QueueStatus;
import launchtools.SimpleQueuePolicy;
import launchtools.SimpleQueueStatus;
import launchtools.UnknownJobException;

public class SingleQueue
implements Queue {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    QueuePolicy policy;
    String name;

    public SingleQueue(QueuePolicy policy) {
        this.policy = policy;
    }

    public SingleQueue() {
        this(new SimpleQueuePolicy());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public QueueStatus getStatus() {
        return new SimpleQueueStatus(this);
    }

    @Override
    public Job getJobStatus(int jobId) throws UnknownJobException {
        return null;
    }

    @Override
    public void deleteJob(int jobId) throws UnknownJobException {
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    synchronized void startNextJob() {
    }

    @Override
    public void resumeJob(int jobId) throws UnknownJobException {
    }

    @Override
    public void suspendJob(int jobId) throws UnknownJobException {
    }

    @Override
    public synchronized void submit(Job job) {
        log.fine("Started job on SingeQueue: " + job);
        String[] command = job.getCommand().getCommand();
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        DataInputStream in = null;
        PrintStream out = null;
        try {
            ProcessRunInfo runInfo = new ProcessRunInfo();
            job.setRunInfo(runInfo);
            job.start();
            process = runtime.exec(command);
            out = new PrintStream(process.getOutputStream());
            String[] standardInput = job.getCommand().getStandardInput();
            if (standardInput != null) {
                for (int i = 0; i < standardInput.length; ++i) {
                    out.println(standardInput[i]);
                }
                out.close();
            }
            in = new DataInputStream(process.getInputStream());
            String line = null;
            while ((line = in.readLine()) != null) {
                runInfo.addLine(line);
            }
            in.close();
        }
        catch (IOException e) {
            job.addException(e);
        }
        job.stop();
        log.fine("Finished job on SingleQueue!");
    }
}

