/*
 * Decompiled with CFR 0.152.
 */
package guitools;

import guitools.BeanEditor;
import guitools.SimpleTextDialog;
import guitools.TextDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class XMLBeanEditor
implements BeanEditor {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean finished = false;
    private Object object;
    private TextDialog textDialog;
    Set<ActionListener> actionListeners = new HashSet<ActionListener>();

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public void launchEdit(Object o, Component parentFrame) {
        this.finished = false;
        StringWriter stringWriter = new StringWriter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(baos);
        e.writeObject(o);
        e.close();
        String xmlString = baos.toString();
        this.textDialog = new SimpleTextDialog(xmlString, new LocalDoneActionListener(), parentFrame);
        String s = this.textDialog.getText();
        StringBufferInputStream stringStream = new StringBufferInputStream(s);
        XMLDecoder d = new XMLDecoder(stringStream);
        Object result = d.readObject();
        d.close();
    }

    public boolean isCancelled() {
        return this.textDialog.isCancelled();
    }

    @Override
    public boolean isFinished() {
        return this.textDialog.isFinished();
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    private class LocalDoneActionListener
    implements ActionListener {
        private LocalDoneActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.fine("Starting LocalDoneActionListener.actionPerformed!");
            String s = XMLBeanEditor.this.textDialog.getText();
            StringBufferInputStream stringStream = new StringBufferInputStream(s);
            XMLDecoder d = new XMLDecoder(stringStream);
            XMLBeanEditor.this.object = d.readObject();
            d.close();
            XMLBeanEditor.this.finished = true;
            if (XMLBeanEditor.this.object != null) {
                StringWriter stringWriter = new StringWriter();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLEncoder enc = new XMLEncoder(baos);
                enc.writeObject(XMLBeanEditor.this.object);
                enc.close();
                String xmlDebugString = baos.toString();
                log.fine("Debug XML output of gerator object: " + NEWLINE + xmlDebugString);
            } else {
                log.warning("Debug XML output of gerator object not possible: object was null! " + NEWLINE);
            }
            Iterator<ActionListener> iterator = XMLBeanEditor.this.actionListeners.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                log.fine("calling listener " + i++ + " of XMLBeanEditor in LocalDoneActionListener.actionPerformed!");
                ActionListener listener = iterator.next();
                listener.actionPerformed(e);
            }
            log.fine("Ending LocalDoneActionListener.actionPerformed!");
        }
    }
}

