/*
 * Decompiled with CFR 0.152.
 */
package graphtools;

import generaltools.TestTools;
import graphtools.IntegerArrayConstraint;
import graphtools.IntegerArrayGenerator;
import graphtools.IntegerArrayIncreasingGenerator;
import graphtools.IntegerArrayMaxDifferentConstraint;
import graphtools.IntegerPermutator;
import graphtools.IntegerPermutatorTools;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.testng.annotations.Test;

public class MappedMaxDiffIntegerPermutator
implements IntegerPermutator {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private IntegerPermutator quantityGenerator;
    private IntegerPermutator posGenerator;
    private List<IntegerArrayConstraint> constraints = new ArrayList<IntegerArrayConstraint>();
    private int toLen;
    private int[] result;
    private int base;
    private int minValue;
    private int maxDiff;

    public MappedMaxDiffIntegerPermutator() {
        this(2, 0, 2, 2);
    }

    public MappedMaxDiffIntegerPermutator(int toLen, int minValue, int maxValue, int maxDiff) {
        assert (maxDiff > 0);
        assert (maxValue >= minValue);
        this.base = maxValue - minValue;
        assert (this.base >= maxDiff);
        this.maxDiff = maxDiff;
        this.minValue = minValue;
        this.toLen = toLen;
        this.quantityGenerator = new IntegerArrayIncreasingGenerator(maxDiff, this.base);
        this.posGenerator = new IntegerArrayGenerator(toLen, maxDiff);
        assert (this.quantityGenerator.size() == maxDiff);
        assert (this.posGenerator.size() == toLen);
        this.reset();
        assert (this.validate());
    }

    @Override
    public void addConstraint(IntegerArrayConstraint constraint) {
        this.constraints.add(constraint);
        this.reset();
        assert (this.validate());
    }

    @Override
    public Object clone() {
        throw new RuntimeException("clone method not supported.");
    }

    @Override
    public BigInteger getTotal() {
        return this.quantityGenerator.getTotal().multiply(this.posGenerator.getTotal());
    }

    @Override
    public boolean hasNext() {
        return this.quantityGenerator.hasNext() || this.posGenerator.hasNext();
    }

    @Override
    public boolean inc() {
        assert (this.hasNext());
        if (!this.hasNext()) {
            return false;
        }
        boolean check = true;
        if (this.posGenerator.hasNext()) {
            this.posGenerator.inc();
        } else {
            this.posGenerator.reset();
            assert (this.posGenerator.validate());
            check = this.quantityGenerator.inc();
        }
        this.update();
        if (!this.validate()) {
            check = false;
        }
        return check;
    }

    private boolean update() {
        int[] posValues;
        if (this.result == null || this.result.length != this.posGenerator.size()) {
            this.result = new int[this.posGenerator.size()];
        }
        if ((posValues = this.posGenerator.get()) == null) {
            return false;
        }
        int[] quantValues = this.quantityGenerator.get();
        if (quantValues == null) {
            return false;
        }
        for (int i = 0; i < posValues.length; ++i) {
            assert (posValues[i] < quantValues.length);
            this.result[i] = quantValues[posValues[i]] + this.minValue;
        }
        return true;
    }

    private void printVec(PrintStream ps, int[] positions) {
        for (int i = 0; i < positions.length; ++i) {
            ps.print(" " + positions[i]);
        }
        ps.println();
    }

    @Override
    public int[] get() {
        if (this.result == null) {
            this.update();
        }
        return this.result;
    }

    @Override
    public int[] next() {
        this.inc();
        return this.get();
    }

    @Override
    public void reset() {
        this.quantityGenerator.reset();
        assert (this.quantityGenerator.validate());
        this.posGenerator.reset();
        assert (this.posGenerator.validate());
        this.update();
        assert (this.validate());
    }

    @Override
    public int size() {
        return this.posGenerator.size();
    }

    @Override
    public boolean validate() {
        if (this.result == null) {
            return false;
        }
        if (!this.quantityGenerator.validate()) {
            return false;
        }
        return this.posGenerator.validate();
    }

    @Test(groups={"new"})
    public void testMappedMaxDiffIntegerPermutator() {
        String methodName = "testMappedMaxDiffIntegerPermutator";
        System.out.println(TestTools.generateMethodHeader(methodName));
        MappedMaxDiffIntegerPermutator gen = new MappedMaxDiffIntegerPermutator(6, 3, 6, 2);
        IntegerArrayMaxDifferentConstraint constraint = new IntegerArrayMaxDifferentConstraint(2);
        int count = 0;
        System.out.println("Results of MappedMaxDiffIntegerPermutator");
        do {
            int[] x = gen.get();
            System.out.print("" + ++count + " : ");
            for (int i = 0; i < x.length; ++i) {
                System.out.print(" " + x[i]);
            }
            System.out.println();
            assert (constraint.validate(x));
        } while (gen.hasNext() && gen.next() != null);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    @Test(groups={"new"})
    public void testMappedMaxDiffIntegerPermutatorRunToEnd() {
        String methodName = "testMappedMaxDiffIntegerPermutator";
        System.out.println(TestTools.generateMethodHeader(methodName));
        MappedMaxDiffIntegerPermutator gen = new MappedMaxDiffIntegerPermutator(6, 3, 6, 2);
        IntegerPermutatorTools.testIntegerPermutatorRunToEnd(gen);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    public String toString() {
        if (this.result == null) {
            return "null";
        }
        String s = "";
        for (int i = 0; i < this.result.length; ++i) {
            s = s + this.result[i] + " ";
        }
        return s;
    }
}

