/*
 * Decompiled with CFR 0.152.
 */
package graphtools;

import generaltools.TestTools;
import graphtools.IntegerArrayConstraint;
import graphtools.IntegerArrayGenerator;
import graphtools.IntegerPermutator;
import graphtools.PermutationGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.testng.annotations.Test;

public class IntegerPermutatorList
extends ArrayList<IntegerPermutator>
implements List<IntegerPermutator>,
IntegerPermutator {
    private boolean initial = false;
    private List<IntegerArrayConstraint> constraints = new ArrayList<IntegerArrayConstraint>();

    public IntegerPermutatorList() {
    }

    public IntegerPermutatorList(IntegerPermutatorList other) {
        this.copy(other);
    }

    @Override
    public void addConstraint(IntegerArrayConstraint constraint) {
        this.constraints.add(constraint);
    }

    @Override
    public boolean add(IntegerPermutator permutator) {
        assert (this.validate());
        assert (permutator.validate());
        super.add(permutator);
        assert (this.validate());
        return true;
    }

    @Override
    public Object clone() {
        return new IntegerPermutatorList(this);
    }

    public void copy(IntegerPermutatorList other) {
        this.clear();
        this.initial = other.initial;
        this.constraints = other.constraints;
        for (IntegerPermutator perm : other) {
            this.add((IntegerPermutator)perm.clone());
        }
    }

    @Override
    public BigInteger getTotal() {
        BigDecimal result = BigDecimal.ONE;
        for (IntegerPermutator perm : this) {
            result = result.multiply(new BigDecimal(perm.getTotal()));
        }
        return result.toBigInteger();
    }

    public void testCurrentTotal() {
        String methodName = "IntegerPermutatorList.testCurrentTotal";
        System.out.println(TestTools.generateMethodHeader(methodName));
        assert (this.hasNext());
        BigInteger firstCount = this.getTotal();
        long count = 0L;
        do {
            System.out.println("" + ++count + " : " + this);
            assert (this.getTotal().equals(firstCount));
        } while (this.hasNext() && this.inc());
        System.out.println("Expected this many iterations: " + firstCount);
        assert (this.getTotal().equals(new BigDecimal("" + count).toBigInteger()));
        assert (!this.hasNext());
        System.out.println(TestTools.generateMethodHeader(methodName));
    }

    @Override
    public int[] get() {
        assert (false);
        return null;
    }

    @Override
    public boolean hasNext() {
        for (IntegerPermutator p : this) {
            if (!p.hasNext()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNext(int n) {
        for (int i = n; i < this.size(); ++i) {
            IntegerPermutator p = (IntegerPermutator)this.get(i);
            if (!p.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean inc() {
        while (this.hasNext()) {
            for (IntegerPermutator p : this) {
                if (p.hasNext()) {
                    p.inc();
                    break;
                }
                p.reset();
            }
            if (!this.validate()) continue;
            return true;
        }
        return false;
    }

    public boolean skip(int n) {
        IntegerPermutator p;
        int i;
        if (this.initial) {
            assert (false);
            this.inc();
        }
        assert (!this.initial);
        for (i = 0; i < n; ++i) {
            p = (IntegerPermutator)this.get(i);
            p.reset();
        }
        for (i = n; i < this.size(); ++i) {
            p = (IntegerPermutator)this.get(i);
            if (p.hasNext()) {
                p.inc();
                return true;
            }
            p.reset();
        }
        return true;
    }

    @Override
    public int[] next() {
        this.inc();
        return this.get();
    }

    @Override
    public void reset() {
        for (IntegerPermutator p : this) {
            p.reset();
        }
    }

    @Override
    public String toString() {
        assert (this.validate());
        StringBuffer buf = new StringBuffer();
        for (IntegerPermutator p : this) {
            assert (p.validate());
            String newString = p.toString();
            assert (newString != null);
            assert (!newString.equals("null"));
            buf.append(newString + " | ");
        }
        return buf.toString();
    }

    @Override
    public boolean validate() {
        for (IntegerPermutator p : this) {
            if (p.validate()) continue;
            return false;
        }
        for (IntegerArrayConstraint constraint : this.constraints) {
            if (constraint.validate(this.get())) continue;
            return false;
        }
        return true;
    }

    @Test(groups={"new"})
    public void testIntegerPermutatorListBasics() {
        String methodName = "testIntegerPermutatorListBasics";
        System.out.println(TestTools.generateMethodHeader(methodName));
        IntegerPermutatorList pList = new IntegerPermutatorList();
        pList.add(new IntegerArrayGenerator(3, 2));
        pList.add(new IntegerArrayGenerator(2, 3));
        int count = 0;
        do {
            System.out.println("" + ++count + " " + pList.toString());
        } while (pList.hasNext() && pList.inc());
        assert (count == 72);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    @Test(groups={"new"})
    public void testIntegerPermutatorListBasics2() {
        String methodName = "testIntegerPermutatorListBasics2";
        System.out.println(TestTools.generateMethodHeader(methodName));
        IntegerPermutatorList pList = new IntegerPermutatorList();
        pList.add(new IntegerArrayGenerator(3, 2));
        pList.add(new PermutationGenerator(3));
        int count = 0;
        do {
            System.out.println("" + ++count + " " + pList.toString());
        } while (pList.hasNext() && pList.inc());
        assert (count == 48);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    @Test(groups={"new"})
    public void testIntegerPermutatorListBasics3() {
        String methodName = "testIntegerPermutatorListBasics3";
        System.out.println(TestTools.generateMethodHeader(methodName));
        IntegerPermutatorList pList = new IntegerPermutatorList();
        pList.add(new IntegerArrayGenerator(2, 2));
        pList.add(new PermutationGenerator(2));
        pList.add(new PermutationGenerator(2));
        pList.add(new IntegerArrayGenerator(2, 2));
        int count = 0;
        do {
            System.out.println("Counter status: " + ++count + " : " + pList.toString());
        } while (pList.hasNext() && pList.inc());
        assert (count == 64);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    @Test(groups={"new"})
    public void testIntegerPermutatorListSkip() {
        String methodName = "testIntegerPermutatorListSkip";
        System.out.println(TestTools.generateMethodHeader(methodName));
        IntegerPermutatorList pList = new IntegerPermutatorList();
        pList.add(new IntegerArrayGenerator(3, 2));
        pList.add(new IntegerArrayGenerator(2, 3));
        assert (pList.size() == 2);
        int count = 0;
        do {
            System.out.println("" + ++count + " " + pList.toString());
        } while (pList.hasNext(1) && pList.skip(1));
        assert (count == 9);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    @Test(groups={"new"})
    public void testIntegerPermutatorListSkip2() {
        String methodName = "testIntegerPermutatorListSkip2";
        System.out.println(TestTools.generateMethodHeader(methodName));
        IntegerPermutatorList pList = new IntegerPermutatorList();
        pList.add(new IntegerArrayGenerator(3, 2));
        pList.add(new IntegerArrayGenerator(2, 3));
        assert (pList.size() == 2);
        for (int i = 0; i < 3; ++i) {
            System.out.println(pList.toString());
            pList.inc();
        }
        int count = 0;
        do {
            System.out.println("" + ++count + " " + pList.toString());
        } while (pList.hasNext(1) && pList.skip(1));
        assert (count == 9);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }
}

