/*
 * Decompiled with CFR 0.152.
 */
package generaltools;

import generaltools.ParsingException;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class StringTools {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final String ENDL = System.getProperty("line.separator");

    public static String paste(String[] words, String separator) {
        if (words == null || words.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(words[0]);
        for (int i = 1; i < words.length; ++i) {
            buf.append(separator);
            buf.append(words[i]);
        }
        return buf.toString();
    }

    public static int indexOfDigit(String word) {
        for (int i = 0; i < word.length(); ++i) {
            if (!Character.isDigit(word.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static String getRightDigits(String s) {
        StringBuffer buf = new StringBuffer();
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(s.charAt(i))) continue;
            buf.append(s.charAt(i));
        }
        return buf.reverse().toString();
    }

    public static String getLeftDigits(String s) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isDigit(s.charAt(i))) continue;
            buf.append(s.charAt(i));
        }
        return buf.toString();
    }

    public static List<Integer> parseSequence(String s) throws ParsingException {
        String[] words = s.split("-");
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (words.length == 1) {
            result.add(new Integer(Integer.parseInt(words[0])));
            return result;
        }
        if (words.length == 2) {
            int min = Integer.parseInt(words[0]);
            int max = Integer.parseInt(words[1]);
            for (int i = min; i <= max; ++i) {
                result.add(new Integer(i));
            }
        } else {
            throw new ParsingException("Expected string of form 3-5 or 7 or 18-9 to specify uninterrupted sequence of numbers.");
        }
        return result;
    }

    public static List<Integer> parseNumbers(String s) throws ParsingException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String[] words = s.split(",");
        for (int i = 0; i < words.length; ++i) {
            result.addAll(StringTools.parseSequence(words[i]));
        }
        return result;
    }

    public static String[] cloneLines(String[] lines) {
        if (lines == null) {
            return null;
        }
        String[] result = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null) continue;
            result[i] = lines[i].substring(0, lines[i].length());
        }
        return result;
    }

    public static int countChar(String s, char c) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static String fillRight(String s, int len, String fill) {
        while (s.length() < len) {
            s = s + fill;
        }
        return s;
    }

    public static String fillLeft(String s, int len, String fill) {
        while (s.length() < len) {
            s = fill + s;
        }
        return s;
    }

    public static String stringWithLength(String s, int len, String fill) {
        if (s.length() > len) {
            return s.substring(0, len);
        }
        if (s.length() == len) {
            return s;
        }
        while (s.length() < len) {
            s = s + fill;
        }
        if (s.length() > len) {
            return s.substring(0, len);
        }
        return s;
    }

    public static void printStride(PrintStream ps, String s, int stride) {
        for (int i = 0; i < s.length(); ++i) {
            if (i > 0 && i % stride == 0) {
                ps.print(" ");
            }
            ps.print(s.substring(i, i + 1));
        }
    }

    public String streamToString(InputStream is) {
        assert (false);
        return null;
    }

    public InputStream stringToStream(String s) {
        assert (false);
        return null;
    }

    public static String stringFromChar(char c) {
        char[] chars = new char[]{c};
        return new String(chars);
    }

    public static String stringFromChar(char c, int n) {
        char[] chars = new char[n];
        for (int i = 0; i < n; ++i) {
            chars[i] = c;
        }
        return new String(chars);
    }

    public static String readWord(InputStream is) {
        DataInputStream dis = new DataInputStream(is);
        String s = new String("");
        char c = ' ';
        do {
            try {
                c = (char)dis.readByte();
            }
            catch (IOException e) {
                break;
            }
        } while (Character.isWhitespace(c));
        if (Character.isWhitespace(c)) {
            log.finest("Found word: " + s);
            return s;
        }
        s = s + c;
        try {
            while (!Character.isWhitespace(c = (char)dis.readByte())) {
                s = s + c;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        log.finest("found word: " + s);
        return s;
    }

    public static String readLine(InputStream is) throws IOException {
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(is));
        return bufReader.readLine();
    }

    public static List<String> convertArrayToList(String[] linesOrig) {
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < linesOrig.length; ++i) {
            lines.add(linesOrig[i]);
        }
        return lines;
    }

    public static String convertArrayToString(String[] linesOrig) {
        StringBuffer buf = new StringBuffer();
        for (String s : linesOrig) {
            buf.append(s + ENDL);
        }
        return buf.toString();
    }

    public static int indexOfString(String[] lines, String word) {
        assert (word != null && lines != null);
        for (int i = 0; i < lines.length; ++i) {
            if (!word.equals(lines[i])) continue;
            return i;
        }
        return -1;
    }

    public static String[] readAllLines(InputStream is) throws IOException {
        String line;
        BufferedReader d = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> lines = new ArrayList<String>();
        do {
            if ((line = d.readLine()) == null) continue;
            lines.add(line);
        } while (line != null);
        String[] result = new String[lines.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)lines.get(i);
        }
        return result;
    }
}

