/*
 * Decompiled with CFR 0.152.
 */
package generaltools;

import java.util.Properties;

public class CommandLineTools {
    public static Properties parseCommandLine(String[] args) {
        Properties result = new Properties();
        for (int i = 0; i < args.length; ++i) {
            result.setProperty("arg" + i, args[i]);
            String[] words = args[i].split("=");
            if (words.length != 2) continue;
            result.setProperty(words[0], words[1]);
        }
        return result;
    }

    public static double getDoubleArg(String name, Properties cli, double defVal) throws NumberFormatException {
        String s = cli.getProperty(name);
        if (s == null) {
            return defVal;
        }
        return Double.parseDouble(s);
    }

    public static double getDoubleArg(String name, Properties cli, Double defVal) throws NumberFormatException {
        return CommandLineTools.getDoubleArg(name, cli, (double)defVal);
    }

    public static int getIntArg(String name, Properties cli, int defVal) throws NumberFormatException {
        String s = cli.getProperty(name);
        if (s == null) {
            return defVal;
        }
        return Integer.parseInt(s);
    }

    public static int getIntArg(String name, Properties cli, Integer defVal) throws NumberFormatException {
        return CommandLineTools.getIntArg(name, cli, (int)defVal);
    }

    public static String getStringArg(String name, Properties cli, String defVal) {
        String s = cli.getProperty(name);
        if (s == null) {
            return defVal;
        }
        return s;
    }
}

