/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.PackageConstants;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TimerCommand
extends AbstractCommand
implements Command {
    private static Map<String, Date> map = new HashMap<String, Date>();
    private static String COMMAND_NAME = "timer";

    public TimerCommand(String name) {
        super(name);
    }

    public TimerCommand() {
        super(COMMAND_NAME);
    }

    @Override
    public Object cloneDeep() {
        return new TimerCommand();
    }

    public void startTimer(String label) {
        assert (map.get(label) == null);
        map.put(label, new Date());
    }

    public long getTimerTime(String label) {
        return new Date().getTime() - map.get(label).getTime();
    }

    public void removeTimer(String label) {
        map.remove(label);
    }

    @Override
    public void executeWithoutUndo() {
        assert (false);
    }

    @Override
    public Command execute() {
        assert (false);
        return null;
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"" + COMMAND_NAME + "\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " [options]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Timer command TODO." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    private String helpOutput() {
        return "Correct usage: " + COMMAND_NAME + " TODO";
    }
}

