/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.AbstractParameter;
import commandtools.Parameter;
import generaltools.ParsingException;

public class StringParameter
extends AbstractParameter
implements Parameter {
    private String value;
    public static final String STRING_NAME = "string";

    public StringParameter(String s) {
        super(STRING_NAME);
        this.value = s;
    }

    public StringParameter(String s, String name) {
        super(name);
        this.value = s;
    }

    @Override
    public Object cloneDeep() {
        return new StringParameter(this.getValue(), this.getName());
    }

    public String getValue() {
        return this.value;
    }

    public boolean parseBoolean() throws ParsingException {
        return StringParameter.parseBoolean(this.value);
    }

    public static boolean parseBoolean(String value) throws ParsingException {
        if (value == null) {
            throw new ParsingException("Could not parse null boolean value string");
        }
        String lc = value.toLowerCase();
        if (lc.equals("true")) {
            return true;
        }
        if (!lc.equals("false")) {
            throw new ParsingException("Could not parse boolean value: " + value);
        }
        return false;
    }

    public void setValue(String s) {
        this.value = s;
    }

    @Override
    public String toString() {
        String name = this.getName();
        if (name == null || name.length() == 0 || name.equals(STRING_NAME)) {
            return this.value;
        }
        return name + "=" + this.value;
    }
}

