/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.BadSyntaxException;
import commandtools.Command;
import commandtools.CommandApplication;
import commandtools.CommandEvent;
import commandtools.CommandException;
import commandtools.CommandHistoryChangeListener;
import commandtools.ForeachCommand;
import commandtools.Interpreter;
import commandtools.SimpleCommand;
import commandtools.UnknownCommandException;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class SimpleCommandApplication
implements CommandApplication {
    protected static Logger log;
    private Command commandHistory;
    private Command lastCommand;
    protected boolean undoMode = true;
    protected Interpreter interpreter;
    private List<CommandHistoryChangeListener> historyListeners = new ArrayList<CommandHistoryChangeListener>();
    private List<Command> undoStack = new ArrayList<Command>();

    public SimpleCommandApplication(Interpreter interpreter, Logger log) {
        this.interpreter = interpreter;
        this.commandHistory = new SimpleCommand();
        SimpleCommandApplication.log = log;
    }

    @Override
    public void addCommandHistoryChangeListener(CommandHistoryChangeListener listener) {
        this.historyListeners.add(listener);
    }

    @Override
    public void fireCommandHistoryChanged(CommandEvent event) {
        for (int i = 0; i < this.historyListeners.size(); ++i) {
            CommandHistoryChangeListener listener = this.historyListeners.get(i);
            listener.commandHistoryChanged(event);
        }
    }

    @Override
    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    public Command getLastCommand() {
        return this.lastCommand;
    }

    @Override
    public Command getCommandHistory() {
        return this.commandHistory;
    }

    private void runCommandInternal(Command command) throws UnknownCommandException {
        assert (this.commandHistory != null);
        if (command == null) {
            throw new UnknownCommandException("Null pointer instead of runnable command encountered!");
        }
        this.commandHistory.addParameter(command);
        this.lastCommand = command;
        this.fireCommandHistoryChanged(new CommandEvent(command));
    }

    @Override
    public void runCommand(Command command) throws CommandException {
        this.runCommandInternal(command);
        Command undoCommand = command.execute();
        if (undoCommand != null) {
            this.undoStack.add(undoCommand);
        } else {
            log.fine("Command cannot be undone, clearing undo stack: " + command.getName());
            this.undoStack.clear();
        }
    }

    public void runCommandWithoutUndo(Command command) throws CommandException {
        this.runCommandInternal(command);
        command.executeWithoutUndo();
    }

    @Override
    public Properties runScriptLine(String line) throws CommandException {
        assert (line != null);
        assert (this.interpreter != null);
        Command command = this.interpreter.interpretLine(line);
        if (command == null) {
            log.fine("Null command encountered in runScript!");
            return null;
        }
        if (command instanceof ForeachCommand) {
            throw new CommandException("Sorry, foreach command is currently only available in non-interactive script mode.");
        }
        if (this.undoMode) {
            this.runCommand(command);
        } else {
            this.runCommandWithoutUndo(command);
        }
        return command.getResultProperties();
    }

    @Override
    public void runScript(InputStream is) throws CommandException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            Command command = null;
            do {
                if ((command = this.interpreter.interpret(reader)) == null) continue;
                if (command.getName().equals("quit")) break;
                if (this.undoMode) {
                    this.runCommand(command);
                    continue;
                }
                this.runCommandWithoutUndo(command);
            } while (command != null);
        }
        catch (EOFException e) {
            log.info("# End of script.");
            return;
        }
        catch (IOException ioe) {
            throw new CommandException(ioe.getMessage());
        }
        catch (UnknownCommandException uce) {
            throw new CommandException(uce.getMessage());
        }
        catch (BadSyntaxException bse) {
            throw new CommandException(bse.getMessage());
        }
    }

    @Override
    public void setUndoMode(boolean b) {
        this.undoMode = b;
    }

    @Override
    public void undo() {
        assert (false);
    }
}

