/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.PackageConstants;

public class QuitCommand
extends AbstractCommand
implements Command {
    public static final String COMMAND_NAME = "quit";

    public QuitCommand() {
        super(COMMAND_NAME);
    }

    @Override
    public Object cloneDeep() {
        QuitCommand result = new QuitCommand();
        for (int i = 0; i < this.getParameterCount(); ++i) {
            result.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return result;
    }

    @Override
    public void executeWithoutUndo() {
        System.exit(0);
    }

    @Override
    public Command execute() {
        System.exit(0);
        return null;
    }

    @Override
    public String toString() {
        return COMMAND_NAME;
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"quit\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Quit command leaves script mode and returns (if possible) to interactive mode. This is mostly useful in conjunction with the source command." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    private String helpOutput() {
        return "Leaves script mode and returns (if possible) to interactive mode. Correct usage: quit";
    }
}

