/*
 * Decompiled with CFR 0.152.
 */
package SecondaryStructureDesign;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;
import rnasecondary.InteractionSet;
import sequence.LetterSymbol;
import sequence.MutableSequence;
import sequence.Residue;
import sequence.SimpleResidue;

public class SequenceEditorWizard
implements GeneralWizard {
    Logger log = Logger.getLogger("NanoTiler_debug");
    public static final int WINDOW_CLOSED = 1;
    private JTable table;
    private JScrollPane scrollPane;
    private JDialog dialog;
    InteractionSet interactions = null;
    private boolean finished = false;
    private ArrayList<ActionListener> listeners = new ArrayList();
    private Object3DGraphController controller;
    private JButton doneButton;
    private JButton addBaseButton;
    private JButton insertBaseButton;
    private JButton removeBaseButton;
    private MutableSequence sequence;

    public SequenceEditorWizard(MutableSequence sequence) {
        this.sequence = sequence;
    }

    public SequenceEditorWizard(MutableSequence sequence, InteractionSet set) {
        this.sequence = sequence;
        this.interactions = set;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    private void createAndShowGUI(Component parentFrame) {
        Frame f = null;
        this.dialog = new JDialog(f, "Sequence Editor Wizard", true);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SequenceEditorWizard.this.fireActionPerformed(new ActionEvent(SequenceEditorWizard.this.dialog, 1, ""));
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.table = new JTable(new SequenceTableModel());
        this.table.setSelectionMode(0);
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int selectedColumn = SequenceEditorWizard.this.table.getSelectedColumn();
                if (selectedColumn > -1) {
                    SequenceEditorWizard.this.insertBaseButton.setEnabled(true);
                    SequenceEditorWizard.this.removeBaseButton.setEnabled(true);
                } else {
                    SequenceEditorWizard.this.insertBaseButton.setEnabled(false);
                    SequenceEditorWizard.this.removeBaseButton.setEnabled(false);
                }
            }
        });
        this.updateTable();
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(new Dimension(450, 150));
        mainPanel.add(this.scrollPane);
        this.doneButton = new JButton("Done");
        this.doneButton.setToolTipText("Submit changes");
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceEditorWizard.this.fireActionPerformed(new ActionEvent(SequenceEditorWizard.this.dialog, 1, ""));
                SequenceEditorWizard.this.dialog.setVisible(false);
                SequenceEditorWizard.this.dialog.dispose();
                SequenceEditorWizard.this.finished = true;
            }
        });
        JPanel sequenceMutatorPanel = new JPanel();
        sequenceMutatorPanel.setLayout(new BoxLayout(sequenceMutatorPanel, 0));
        this.insertBaseButton = new JButton("Insert");
        this.insertBaseButton.setToolTipText("Insert base to the left of selected column");
        this.insertBaseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] symbols = SequenceEditorWizard.this.getAlphabetSymbols();
                int selectedColumn = SequenceEditorWizard.this.table.getSelectedColumn();
                int choice = JOptionPane.showOptionDialog(SequenceEditorWizard.this.dialog, "Select base", "Add new base", 0, 3, null, symbols, symbols[0]);
                if (choice != -1) {
                    int size = SequenceEditorWizard.this.sequence.size();
                    SequenceEditorWizard.this.sequence.insertResidue(new SimpleResidue((LetterSymbol)symbols[choice], SequenceEditorWizard.this.sequence, selectedColumn), selectedColumn);
                    SequenceEditorWizard.this.table.addColumn(new TableColumn(size));
                    SequenceEditorWizard.this.updateTable();
                }
            }
        });
        this.insertBaseButton.setEnabled(false);
        this.addBaseButton = new JButton("Add");
        this.addBaseButton.setToolTipText("Add base at end of sequence");
        this.addBaseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] symbols = SequenceEditorWizard.this.getAlphabetSymbols();
                int choice = JOptionPane.showOptionDialog(SequenceEditorWizard.this.dialog, "Select base", "Add new base", 0, 3, null, symbols, symbols[0]);
                if (choice != -1) {
                    SequenceEditorWizard.this.log.info("Selected option: " + choice);
                    int size = SequenceEditorWizard.this.sequence.size();
                    SequenceEditorWizard.this.sequence.addResidue(new SimpleResidue((LetterSymbol)symbols[choice], SequenceEditorWizard.this.sequence, size));
                    SequenceEditorWizard.this.table.addColumn(new TableColumn(size));
                    SequenceEditorWizard.this.updateTable();
                }
            }
        });
        this.removeBaseButton = new JButton("Remove");
        this.removeBaseButton.setToolTipText("Remove the selected base");
        this.removeBaseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Residue r = SequenceEditorWizard.this.sequence.getResidue(SequenceEditorWizard.this.table.getSelectedColumn());
                SequenceEditorWizard.this.handleInteractionRemoval(r);
                SequenceEditorWizard.this.sequence.removeResidue(SequenceEditorWizard.this.table.getSelectedColumn());
                SequenceEditorWizard.this.table.removeColumn(SequenceEditorWizard.this.table.getColumnModel().getColumn(SequenceEditorWizard.this.table.getColumnModel().getColumnCount() - 1));
                SequenceEditorWizard.this.table.clearSelection();
                SequenceEditorWizard.this.removeBaseButton.setEnabled(false);
                SequenceEditorWizard.this.insertBaseButton.setEnabled(false);
            }
        });
        this.removeBaseButton.setEnabled(false);
        JPanel temp1 = new JPanel();
        temp1.setLayout(new BoxLayout(temp1, 1));
        temp1.add(sequenceMutatorPanel);
        temp1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Sequence Mutation Operations"));
        sequenceMutatorPanel.add(this.insertBaseButton);
        sequenceMutatorPanel.add(Box.createHorizontalStrut(5));
        sequenceMutatorPanel.add(this.addBaseButton);
        sequenceMutatorPanel.add(Box.createHorizontalStrut(5));
        sequenceMutatorPanel.add(this.removeBaseButton);
        temp1.add(sequenceMutatorPanel);
        temp1.setAlignmentY(0.5f);
        mainPanel.add(temp1);
        mainPanel.add(Box.createVerticalGlue());
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        this.doneButton.setAlignmentY(0.5f);
        panel2.add(this.doneButton);
        panel2.setAlignmentY(0.5f);
        mainPanel.add(panel2);
        this.dialog.add(mainPanel);
        this.dialog.pack();
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setLocationRelativeTo(parentFrame);
        this.dialog.setVisible(true);
    }

    private void handleInteractionRemoval(Residue r) {
        if (this.interactions == null) {
            return;
        }
        for (int i = 0; i < this.interactions.size(); ++i) {
            Residue r1 = this.interactions.get(i).getResidue1();
            Residue r2 = this.interactions.get(i).getResidue2();
            if (r1.isSameSequence(r) && r1.getPos() == r.getPos() || r2.isSameSequence(r) && r2.getPos() == r.getPos()) {
                this.log.info("Removing residue " + r);
                this.interactions.remove(this.interactions.get(i));
                continue;
            }
            this.log.info("Test did not work!\n");
        }
    }

    @Override
    public void launchWizard(Object3DGraphController controller, Component parentFrame) {
        this.controller = controller;
        final Component c = parentFrame;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SequenceEditorWizard.this.createAndShowGUI(c);
            }
        });
    }

    public void setSequence(MutableSequence s) {
        this.sequence = s;
        this.updateTable();
    }

    private Object[] getAlphabetSymbols() {
        Object[] symbols = new Object[this.sequence.getAlphabet().size()];
        for (int i = 0; i < this.sequence.getAlphabet().size(); ++i) {
            System.out.println(this.sequence.getAlphabet());
            symbols[i] = this.sequence.getAlphabet().getSymbol(i);
        }
        return symbols;
    }

    private void updateTable() {
        this.table.revalidate();
        for (int i = 0; i < this.sequence.size(); ++i) {
            JComboBox<Object> box = new JComboBox<Object>(this.getAlphabetSymbols());
            this.table.getColumnModel().getColumn(i).setCellEditor(new DefaultCellEditor(box));
            this.table.getColumnModel().getColumn(i).setPreferredWidth(45);
        }
        this.table.revalidate();
    }

    public void fireActionPerformed(ActionEvent e) {
        for (ActionListener l : this.listeners) {
            l.actionPerformed(e);
        }
    }

    private class SequenceTableModel
    extends AbstractTableModel {
        private SequenceTableModel() {
        }

        @Override
        public int getColumnCount() {
            return SequenceEditorWizard.this.sequence.size();
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return SequenceEditorWizard.this.sequence.getResidue(column).getSymbol();
        }

        @Override
        public String getColumnName(int column) {
            return Integer.toString(column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
            SequenceEditorWizard.this.sequence.mutateResidue(new SimpleResidue((LetterSymbol)o, SequenceEditorWizard.this.sequence, column), column);
        }
    }
}

