/*
 * Decompiled with CFR 0.152.
 */
package SecondaryStructureDesign;

import generaltools.Randomizer;
import java.awt.Color;
import java.util.Random;

public class ColorGradientMixer {
    private int red;
    private int green;
    private int blue;
    private int redIncrease;
    private int greenIncrease;
    private int blueIncrease;
    private Random r = Randomizer.getInstance();
    private int factor;

    public ColorGradientMixer(Color color) {
        this(color, 10);
    }

    public ColorGradientMixer(int red, int green, int blue) {
        this(red, green, blue, 10);
    }

    public ColorGradientMixer(int red, int green, int blue, int factor) {
        this(new Color(red, green, blue), factor);
    }

    public ColorGradientMixer(Color color, int factor) {
        this.factor = factor;
        this.red = color.getRed();
        this.green = color.getGreen();
        this.blue = color.getBlue();
        this.initialize(factor);
    }

    public Color nextColor() {
        if (this.red + this.redIncrease <= 150) {
            this.redIncrease = this.r.nextInt(this.factor) + this.factor / 2;
        } else if (this.red + this.redIncrease >= 255) {
            this.redIncrease = (this.r.nextInt(this.factor) + this.factor / 2) * -1;
        }
        if (this.blue + this.blueIncrease <= 150) {
            this.blueIncrease = this.r.nextInt(this.factor) + this.factor / 2;
        } else if (this.blue + this.blueIncrease >= 255) {
            this.blueIncrease = (this.r.nextInt(this.factor) + this.factor / 2) * -1;
        }
        if (this.green + this.greenIncrease <= 150) {
            this.greenIncrease = this.r.nextInt(this.factor) + this.factor / 2;
        } else if (this.green + this.greenIncrease >= 255) {
            this.greenIncrease = (this.r.nextInt(this.factor) + this.factor / 2) * -1;
        }
        this.red += this.redIncrease;
        this.blue += this.blueIncrease;
        this.green += this.greenIncrease;
        return new Color(this.red, this.green, this.blue);
    }

    private void initialize(int factor) {
        this.redIncrease = this.r.nextInt(factor * 2) - factor;
        this.blueIncrease = this.r.nextInt(factor * 2) - factor;
        this.greenIncrease = this.r.nextInt(factor * 2) - factor;
    }
}

