// -*- C++ -*-

#ifndef __TIMER__
#define __TIMER__

extern "C" {
#include <time.h>
}
#include <iostream>

using namespace std;

class Timer {
public:
  Timer() : startTime(0), stopTime(0) {}

  inline void start() { time(&startTime); }
  inline void stop() { time(&stopTime); }
  inline void reset() { 
    startTime = 0; 
    stopTime = 0; 
  }

  int seconds() const;
  int minutes() const;
  int hours() const;
  int totalSeconds() const { 
    return static_cast<int>((stopTime - startTime));
  }

  friend ostream& operator << (ostream& os, const Timer& time);
  friend bool operator == (const Timer& left, const Timer& right);

protected:
  time_t startTime;
  time_t stopTime;  
};  

ostream& operator << (ostream& os, const Timer& time);

#endif


