#ifndef _LOGGER_H_
#define _LOGGER_H_

#include <iostream>

class Logger {
 private:
  ostream * osp;
 public:

  Logger() : osp(&cout) { }

  Logger(ostream * _osp) { osp = _osp; }

  virtual ~Logger() { }

  void fine(const string& s) const {
    (*osp) << s << endl;
  }

  void log(const string& s) const {
    (*osp) << s << endl;
  }

  void finest(const string& s) const {
    (*osp) << s << endl;
  }

  void info(const string& s) const {
    (*osp) << s << endl;
  }

  void warning(const string& s) const {
    (*osp) << "Warning: " << s << endl;
  }

};

#endif
