#include <FileName.h>

// add a slash to end of string if not already there 
void
addSlash(string & s)
{
  if (s.size() == 0) {
    return;
    // s = "./";
  }
  if (s[s.size()-1] != '/') {
    s = s + "/";
  }
}

// add path to non absolute filename
void addPathIfRelative(string& s, const string& path)
{
  if (s.size() < 1) {
    return;
  }
  string p = path;
  if ( (s[0] != '/') && (s[0] != '.') ){
    addSlash(p);
    s = p + s;
  }
}

/** returns base name of file (not returning path and ending */
string fileNameBase(const string &pathName )
{
  string result = pathName;
  if( result.find_last_of('/') < result.size() ) {
    result.erase( 0, (result.find_last_of('/')+1) ); 
  }
  if( result.find_last_of('.') < result.size() ) {
    if( (result.size() < result.find_last_of('/')) ||
	(result.find_last_of('/') < result.find_last_of('.')) )
      {
	result.erase( result.find_last_of('.') );  
      }
  }
  return result;
}
