#ifndef __CLASSIFICATION_RESULT__
#define __CLASSIFICATION_RESULT__

#include <math.h>

class ClassificationResult {

 public:

  ClassificationResult() : truePos(0), trueNeg(0), falsePos(0), falseNeg(0) 
    { }

  virtual ~ClassificationResult() { }

  /** compute accuracy according to Juan & Wilson: tp / (tp + fp + fn) */
  double computeAccuracyJW() {
    double denom = truePos + falsePos + falseNeg;
    if (denom > 0.0) {
      return truePos / denom;
    }
    return 0.0; // denominator undefined
  }

  double computeMatthews() {
    double head = static_cast<double>((truePos * trueNeg)) 
      - static_cast<double>((falsePos * falseNeg));
    double denom = static_cast<double>(trueNeg + falseNeg) 
      * static_cast<double>(trueNeg + falsePos)
               * static_cast<double>(truePos + falseNeg) 
      * static_cast<double>(truePos + falsePos);
    return head / sqrt(denom);
  }

  bool isMatthewsDefined() {
    double denom = static_cast<double>(trueNeg + falseNeg) 
      * static_cast<double>(trueNeg + falsePos)
               * static_cast<double>(truePos + falseNeg) 
      * static_cast<double>(truePos + falsePos);
    return (denom > 0.0);
  }

  /** what fraction of predictions was correct ? */
  double computeSelectivity() {
    double allPred = truePos + falsePos; // sum of all predictions
    if (allPred > 0) {
      return truePos / allPred;
    }
    return 0.0;
  }

  /** what fraction of true identities was found ? */
  double computeSensitivity() {
    double trueSum = truePos + falseNeg; // sum of all entities to be pred. pos
    if (trueSum > 0) {
      return truePos / trueSum;
    }
    return 0.0;
  }

  /** what fraction of predictions was correct ? */
  bool isSelectivityDefined() {
    int allPred = truePos + falsePos; // sum of all predictions
    return (allPred > 0);
  }

  /** what fraction of predictions was correct ? */
  bool isSensitivityDefined() {
    int trueSum = truePos + falseNeg; // sum of all predictions
    return (trueSum > 0);
  }


  int truePos;

  int trueNeg;

  int falsePos;

  int falseNeg;

};

#endif
