#ifndef _SEQUENCE_ALIGNMENT_IO_TOOLS_
#define _SEQUENCE_ALIGNMENT_IO_TOOLS_

#include <iostream>
#include <debug.h>
#include <SequenceAlignment.h>
#include <StringTools.h>

const int MSF_CHUNK = 50;
const int MSF_STRIDE = 10;
const int CLUSTAL_CHUNK = 60;

const unsigned int MSF_NAME_MAX = 9; // TODO verify
const unsigned int CLUSTAL_NAME_MAX = 10; // TODO verify

class SequenceAlignmentIOTools {

 public:
  
  typedef SequenceAlignment::size_type size_type;

  static void writeFasta(ostream& os,
			 const SequenceAlignment& ali,
			 size_type blockLength);

  static void writeMsf(ostream& os, const SequenceAlignment& ali, const string& alphabet) {
    char seqType = getMsfSequenceType(alphabet);
    writeMsfHeader(os, ali, seqType);
    os << "//" << endl;
    os << endl;
    writeMsfBody(os, ali);
  }

  static void writeClustal(ostream& os, const SequenceAlignment& ali, const string& alphabet) {
    writeClustalHeader(os, ali);
    os << endl;
    writeClustalBody(os, ali);
  }

  /** writes IG/Standford format */
  static void writeStanford(ostream& os,
			    const SequenceAlignment& ali);

 private:

  static char getMsfSequenceType(const string& alphabet);

  static string getMsfName(const SequenceAlignment& ali,
			   SequenceAlignment::size_type n);

  static void writeMsfHeader(ostream& os, const SequenceAlignment& ali, char sequenceType);

  /** writes string with space character every 10 (stride) characters. */
  static void writeStride(ostream& os,
			  const string& s, 
			  int stride);

  static void writeMsfSequenceChunk(ostream& os, const SequenceAlignment& ali,
				    SequenceAlignment::size_type n,
				    SequenceAlignment::size_type start);

  static void writeMsfBody(ostream& os, const SequenceAlignment& ali);



  static string getClustalName(const SequenceAlignment& ali,
			   SequenceAlignment::size_type n);
  static string getClustalEmptyName();

  static void writeClustalHeader(ostream& os, const SequenceAlignment& ali);

  static void writeClustalSequenceChunk(ostream& os, const SequenceAlignment& ali,
					SequenceAlignment::size_type n,
					SequenceAlignment::size_type start);

  static void writeClustalDummyChunk(ostream& os, const SequenceAlignment& ali,
				     SequenceAlignment::size_type start);

  static void writeClustalBody(ostream& os, const SequenceAlignment& ali);


 private:

  static void writeFastaSequence(ostream& os,
				 const SequenceAlignment& ali,
				 size_type n,
				 size_type blockLength);

};

#endif
