#include <math.h>
#include <debug.h>
#include <numberformat.h>
#include <iostream>

using namespace std;

/* return closes engineering exponent */
int
engineeringExponent(int n)
{
  for (int i = 0; i < 3; ++i) {
    if (((n-i) % 3) == 0) {
      return n - i;
    } 
  }
  ERROR("Internal error in line 20!");
  return n;
}

char 
engineeringChar(int n) {
  switch (n) {
  case 12: return 'T';
  case 9: return 'G';
  case 6: return 'M';
  case 3: return 'K';
  case 0: return ' ';
  case -3: return 'm';
  case -6: return 'u';
  case -9: return 'n';
  case -12: return 'p';
  case -15: return 'f';
  default: return ' ';
  }
  return ' ';
}




double
engineering(double x, int& ex, char& c)
{
  // first get the exponent:
  int intexp = static_cast<int>(floor(log10(x)));
  ex = engineeringExponent(intexp);
  c = engineeringChar(ex);
  int expDiff = intexp - ex;
  return x * pow(10.0, expDiff);
}




