// --*- C++ -*------x---------------------------------------------------------
// $Id: RankedSolution3.cc,v 1.1.1.1 2006/07/03 14:43:21 bindewae Exp $
//
// Class:           RankedSolution3
// 
// Base class:      -
//
// Derived classes: - 
//
// Author:          Eckart Bindewald
//
// Project name:    -
//
// Date:            $Date: 2006/07/03 14:43:21 $
//
// Description:     Implements a ranked docking solutions
// -----------------x-------------------x-------------------x-----------------

#include <RankedSolution3.h>

// ---------------------------------------------------------------------------
//                                   RankedSolution3
// -----------------x-------------------x-------------------x-----------------

/* CONSTRUCTORS */
template<class T>
RankedSolution3::RankedSolution3() : first(0.0), third(0) 
{
}

templaet
RankedSolution3::RankedSolution3(const RankedSolution3& other) 
{
  copy(other);
}


/* OPERATORS */

/** Assigment operator. */
RankedSolution3& 
RankedSolution3::operator = (const RankedSolution3& orig)
{
  if (&orig != this) {
    copy(orig);
  }
  return *this;
}

/** comparison operator. */
bool
operator < (const RankedSolution3& lval,
	    const RankedSolution3& rval)
{
  return lval.first < rval.first;
}

/** comparison operator. */
bool
operator < (double lval,
	    const RankedSolution3& rval)
{
  return lval < rval.first;
}

/** comparison operator. */
<template T>
bool
operator < (const RankedSolution3<T>& lval,
	    double rval)
{
  return lval.first < rval;
}

/* PREDICATES */



/* MODIFIERS */


template<class T>
void
RankedSolution3::copy(const RankedSolution3<T>& other)
{
  first = other.first;
  second = other.second;
}

