#include <IntervallIntSet.h>

/** Adds padding to all intervalls, avoiding overlaps and collisions */
void
IntervallIntSet::addPadding(index_type padding, index_type indexMin, index_type indexMax) {
  if (size() == 0) {
    return;
  }
  addPadding(padding, indexMin, indexMax, 0, indexMin-1, intervalls[1].getLower()); // special case for first intervall
  for (size_type i = 1; (i + 1) < size(); ++i) {
    addPadding(padding, indexMin, indexMax, i, intervalls[i-1].getUpper(), intervalls[i+1].getLower());
  }
  if (size() > 1) {
    addPadding(padding, indexMin, indexMax, size()-1, intervalls[size()-2].getUpper(), indexMax+1); // special case for last intervall
  }
}

/** Adds padding to all intervalls, avoiding overlaps and collisions.
 Index min / max are inclusive intervall descriptors for maximum and minium values of interval bounds. */
void
IntervallIntSet::addPadding(index_type padding, index_type indexMin, index_type indexMax, 
			    size_type n, index_type prevUpper, index_type nextLower) {
  index_type low = intervalls[n].getLower();
  index_type up = intervalls[n].getUpper();
  low -= padding;
  up += padding;
  if (low <= prevUpper) {
    low = prevUpper + 1;
  }
  if (up >= nextLower) {
    up = nextLower - 1;
  }
  if (low < indexMin) {
    low = indexMin;
  }
  if (up > indexMax) {
    up = indexMax;
  }
  intervalls[n].setLower(low);
  intervalls[n].setUpper(up);
}

/** Make sure not intervalls are overlapping. Slow: square complexity! :-( FIXIT */
/*
void
IntervallIntSet::consolidate() {
    bool allOk = true;
    do {
      allOk = true;
      for (int i = static_cast<int>(intervalls.size()) -1; i >= 0; --i) {
	for (int j = 0; j < i; ++j) {
	  if (intervalls[i].isOverlapping(intervalls[j])) {
	    allOk = false;
	    intervalls[j].consolidate(intervalls[i]);
	    intervalls.erase(intervalls.begin()+i);
	    break;
	  }
	}
	if (!allOk) {
	  break;
	}
      }
    }
    while (!allOk);
}
*/

/** Make sure not intervalls are overlapping. Potentially large memory :-( FIXIT */
void
IntervallIntSet::consolidate() {
  int contentDiff = upper - lower + 1;
  const int EMPTY = 0;
  const int FULL = 0;
  Vec<int> ary(contentDiff, EMPTY);
  for (size_type i = 0; i < intervalls.size(); i++) {
    int low = intervalls[i].getLower() - getLower();
    int up = intervalls[i].getUpper() - getLower();
    ASSERT(low >= 0);
    ASSERT(up < static_cast<int>(ary.size()));
    for (int j = low; j <= up; j++) {
      ary[j] = FULL;
    }
  }
  size_type sz = size();
  intervalls.clear();
  intervalls.reserve(sz); // at least this many intervalls
  // count intervalls:
  Vec<int>::iterator first = ary.begin();
  Vec<int>::iterator last = ary.end();
  Vec<int>::iterator stopId = first;
  for (Vec<int>::iterator startId = first; (startId != last) && (stopId != last); startId = stopId + 1) { // notice the unusual increment
    startId = find(startId, last, FULL);
    if (startId != last) {
      stopId = find(startId + 1, last, EMPTY);
      ASSERT(startId != stopId);
      intervalls.push_back(IntervallInt(distance(first, startId) + getLower(), distance(first, stopId) - 1 + getLower())); // do not include first non full position
    }
  }
}

