#include <string>
#include <iostream>
#include <fstream>
#include <MAFAlignment.h>
#include <debug.h>

using namespace std;

// Unload (temporarily save to disk to save RAM memory) alignment blocks with more than this many characters:
MAFAlignment::length_type MAFAlignment::unloadCharLimit = 10000;

int
main(int argc, char** argv) {
  MAFAlignment maf;
  if (argc != 3) {
    ERROR("Usage: fasta2maf FASTAFILE ASSEMBLY");
  }
  ifstream inputFile(argv[1]);
  ERROR_IF(!inputFile, "Error opening input file!");
  string assembly(argv[2]);
  maf.setRefAssembly(assembly);
  maf.readFASTA(inputFile);
  maf.writeMAF(cout);
  inputFile.close();
  return 0;
}
