// --*- C++ -*------x---------------------------------------------------------
#ifndef __INTERACTION_CLUSTER_ANALYZER_TEST__
#define __INTERACTION_CLUSTER_ANALYZER_TEST__

#include <InteractionClusterAnalyzer.h>
#include <generalNumerics.h>

using namespace std;

class InteractionClusterAnalyzerTest {

private:

  static InteractionClusterAnalyzer clusterAnalyzer; 

 public:

  typedef InteractionClusterAnalyzer::index_type index_type;

  static void testAll() {
    testComputeStemInvariantPAll();
    testComputeStemInvariantP();
    testComputeStemInvariantP2();
    testComputeStem5InvariantBiasP();
    testComputeStemPairInvariantBiasP();
    testLogFactorial();
    testLogNOverK();
  }

  static void testLogFactorial() {
    for (int i = 0; i < 30; ++i) {
      cout << i << " fac: " << factorial(i) << " log-fac: " <<exp( logFactorial(i) ) 
	   << " " << logFactorial(i) << endl;
      ASSERT(isSimilar(factorial(i)/exp(logFactorial(i)), 1.0));
    }
  }

  static void testLogNOverK() {
    for (int n = 1; n < 30; ++n) {
      for (int k = 1; k <= n; ++k) {
	cout << n << " " << k << " n choose k: " << nOverK(n,k) << " log-fac: " <<exp( logNOverK(n,k) ) 
	     << " " << logNOverK(n,k) << endl;
	ASSERT(isSimilar(nOverK(n,k)/exp(logNOverK(n,k)), 1.0));
      }
    }
  }

  static void testComputeStemInvariantP() {
    index_type numCats = 108;
    index_type numTrials = 6;
    index_type nonzeros = 6;
    double p = clusterAnalyzer.computeStemInvariantP(numCats, numTrials, nonzeros);
    cout << numCats << " " << numTrials << " " << nonzeros << " " << p << endl;
    if (p > 1.0) {
      double f1 = exp(logNOverK(numCats, nonzeros));
      double f2 = pow(nonzeros/static_cast<double>(numCats), numTrials);
      cout << f1 << " " << f2 << " " << f1*f2 << endl;
    }
    ASSERT(p <= 1.0);
  }

  static void testComputeStemInvariantP2() {
    index_type numCats = 211;
    index_type numTrials = 11;
    index_type nonzeros = 10;
    double p = clusterAnalyzer.computeStemInvariantP(numCats, numTrials, nonzeros);
    cout << numCats << " " << numTrials << " " << nonzeros << " " << p << endl;
    if (p > 1.0) {
      double f1 = exp(logNOverK(numCats, nonzeros));
      double f2 = pow(nonzeros/static_cast<double>(numCats), numTrials);
      cout << f1 << " " << f2 << " " << f1*f2 << endl;
    }
    ASSERT(p < 1.0);
  }

  static void testComputeStemInvariantPAll() {
    string methodName="testComputeStemInvariantPAll";
    cout << "Starting " << methodName << endl;
    for (index_type numCats = 2; numCats <= 20; ++numCats) {
      for (index_type numTrials = 1; numTrials <= numCats; ++numTrials) {
	for (index_type nonzeros = 1; nonzeros <= numTrials; ++nonzeros) {
	  double p = clusterAnalyzer.computeStemInvariantP(numCats, numTrials, nonzeros);
	  cout << numCats << " " << numTrials << " " << nonzeros << " " << p << endl;
	  if (p > 1.0) {
	    double f1 = exp(logNOverK(numCats, nonzeros));
	    double f2 = pow(nonzeros/static_cast<double>(numCats), numTrials);
	    cout << f1 << " " << f2 << " " << f1*f2 << endl;
	  }
	  // INVARIANT((p >= 0) && (p <= 1.0));
	  // INVARIANT(((nonzeros == numTrials) && (p == 1.0) ) || (p < 1.0));
	}
      }
    }
    cout << "Starting " << methodName << endl;
  }

  static void testComputeStem5InvariantBiasP() {
    Stem stem(15,37, 5);
    Vec<Stem> stems(1, stem);
    index_type clusterCutoff = 30; 
    double p = clusterAnalyzer.computeStemInvariantBiasP(stems, clusterCutoff,true);
    cout << stems << endl;
    cout << "p-value: " << p << endl;
    ASSERT(p < 1.0);
  }

  static void testComputeStemPairInvariantBiasP() {
    Stem stem1(15,37, 1);
    Stem stem2(16,42, 1); // NOT a diagonal
    Vec<Stem> stems;
    stems.push_back(stem1);
    stems.push_back(stem2);
    index_type clusterCutoff = 30; 
    double p = clusterAnalyzer.computeStemInvariantBiasP(stems, clusterCutoff,true);
    cout << stems << endl;
    cout << "p-value: " << p << endl;
    ASSERT(p == 1.0);
  }
  
};

#endif
