#ifndef __SEQUENCE_STAT__
#define __SEQUENCE_STAT__

#include <Vec.h>
#include <debug.h>
#include <string>
#include <algorithm>
#include <SequenceAlignment.h>

/** returns quality score according to Thompson 2001 (JMB). 
    So far not normalized. */
double
computeMD(const Vec<Vec<int> >& ali,
	  const Vec<Vec<int> >& sub);

double
computeMD(const Vec<string>& aliOrig,
	  const Vec<Vec<int> >& sub,
	  const string& alpbabet);


/** see paper by Thompson 2001 JMB. Still not implemented factor "LQRID" of paper */
double
computeNormMD(const Vec<Vec<int> >& ali,
	      const Vec<Vec<int> >& sub,
	      double gOpen, double gExt);

/** see paper by Thompson 2001 JMB. Still not implemented factor "LQRID" of paper */
double
computeNormMD(const Vec<string>& ali,
	      const Vec<Vec<int> >& sub,
	      const string& alphabet,
	      double gOpen, double gExt);

/** returns true if all characters are part of alignment alphabet */
bool
checkAlignmentString(const string& s, const string& alphabet,
		     char gapChar);

/** returns true if all characters are part of alignment alphabet, replaces bad characters with repairChar */
bool
checkAndRepairAlignmentString(string& s, const string& alphabet,
			      char gapChar, char repairChar);

/** returns zero for correct alignment, error code otherwise */
string
checkAlignment(SequenceAlignment& ali, const string& alphabet, char gapChar);

/** returns zero for correct alignment, error code otherwise */
string
checkAndRepairAlignment(SequenceAlignment& ali, const string& alphabet, char gapChar, char repairChar);

void
cleanAlignment(SequenceAlignment& ali);

#endif
