// -*-C++-*-------------------------------------------------------------------
#ifndef GET_ARG_H 
#define GET_ARG_H 

#include <iostream>
#include <string.h>
#include <cstdarg>
#include <string>
#include <vector>
#include <debug.h>
#include <StringTools.h> // convert number to string and and vice versa
#include <malloc.h>

// "value" has only one "word" as input, set default value (if
// wanted), set gotten path AND default value (if wanted):
void 
getArg( const char *option, string &value, 
	     int argc, char *argv[], string defaultValue = "",
	     bool justOption = false );

/** set flag to true, if option is present */
void 
getArg( const char *option, bool &flag, 
	     int argc, char *argv[]);

void 
getArg( const char *option, int &value, 
	     int argc, char *argv[], int defaultValue = 0 );

void 
getArg( const char *option, unsigned int &value, 
	     int argc, char *argv[], unsigned int defaultValue = 0 );

void 
getArg( const char *option, long &value, 
	     int argc, char *argv[], long defaultValue  = 0);

void 
getArg( const char *option, unsigned long &value, 
	     int argc, char *argv[], unsigned long defaultValue  = 0);

void 
getArg( const char *option, float &value, 
	     int argc, char *argv[], float defaultValue = 0 );

void 
getArg( const char *option, double &value, 
	     int argc, char *argv[], double defaultValue = 0 );

void 
getArg( const char *option, vector<int> &value, 
	     int argc, char *argv[],bool twiceSameNumber = true );

void 
getArg( const char *option, vector<unsigned int> &value, 
	     int argc, char *argv[]);

void 
getArg( const char *option, vector<double> &value, 
	     int argc, char *argv[]);

void 
getArg( const char *option, vector<string> &value, 
	     int argc, char *argv[],
	     bool twiceSameNumber = true );

/** checks commando line wether all options are correct. */
void 
checkArg( int argc, char *argv[], int optionNumber ... );

void 
checkArg( string text, int argc, char *argv[], 
	       int optionNumber ... );

/** converts input file to argc and argv */
char **
streamToCommands( istream& is, int& argc, const string& name = "" );

/** tests commando line, if all options are correct. */
bool 
testArg( int argc, char *argv[], int optionNumber ... );

/** returns true, if option is present in command line. */
bool
isPresent( const string& option , int argc, char* argv[]);

/** output of parameter. */
template<class T>
inline
void 
printArg( const char *option, const T& x )
{
  cout << "-" << option << " : " << x << endl;
}

/** output of parameter. */
template<class T>
inline
void 
printArg( ostream& os, const char *option, const T& x )
{
  os << "-" << option << " : " << x << endl;
}



#endif // __GET_ARG_H__










