#ifndef _SIMPLE_SEQUENCE_ALIGNMENT_TEST__
#define _SIMPLE_SEQUENCE_ALIGNMENT_TEST__

#include <SimpleSequenceAlignment.h>
#include <iostream>
#include <fstream>

// use namespace std;

class SimpleSequenceAlignmentTest {

 public:

  static void testAll() {
    testRandomShuffle();
    testRandomShuffleGapPreserving();
  }

  static void testRandomShuffle() {
    string methodName = "testRandomShuffle";
    cout << "# Starting " << methodName << endl;
    SimpleSequenceAlignment ali;
    bool keepFirstFixed = true;
    string filename = "../../test/fixtures/anticodon_simple2.fa";
    ifstream ifs(filename.c_str());
    ERROR_IF(!ifs, "Error opening file " + filename);
    ali.readFasta(ifs);
    cout << ali << endl;
    ali.randomShuffleColumns(keepFirstFixed);
    cout << ali << endl;
    cout << "# Finished " << methodName << endl;
  }

  static void testRandomShuffleGapPreserving() {
    string methodName = "testRandomShuffleGapPreserving";
    cout << "# Starting " << methodName << endl;
    SimpleSequenceAlignment ali;
    bool keepFirstFixed = true;
    string filename = "../../test/fixtures/anticodon_simple2.fa";
    ifstream ifs(filename.c_str());
    ERROR_IF(!ifs, "Error opening file " + filename);
    ali.readFasta(ifs);
    cout << "# Original alignment:" << endl;
    cout << ali << endl;
    SequenceAlignment::sequence_type firstSeq = ali.getSequence(0);
    ali.randomShuffleColumnsGapPreserving(keepFirstFixed);
    cout << "# Alignment after gap-preserving column shuffling (first sequence fixed):" << endl;
    cout << ali << endl;
    ERROR_IF(ali.getSequence(0) != firstSeq, "First sequence has improperly changed after gap-preserving column shuffling.");
    ali.randomShuffleColumnsGapPreserving(!keepFirstFixed);
    cout << "# Alignment after gap-preserving column shuffling (first sequence not fixed):" << endl;
    cout << ali << endl;
    ERROR_IF(ali.getSequence(0) == firstSeq, "First sequence has not changed after gap-preserving column shuffling.");
    cout << "# Finished " << methodName << endl;
  }

}; 

#endif
