// --*- C++ -*------x---------------------------------------------------------
// $Id: SequenceMutator.h,v 1.2 2011/08/02 13:46:32 bindewae Exp $
//
// Class:           SequenceMutator
// 
// Base class:      -
//
// Derived classes: - 
//
// Author:          Eckart Bindewald
//
// Description:     Generates a set of sequences with gaps.
// 
// Reviewed by:     -
// -----------------x-------------------x-------------------x-----------------

#ifndef __SEQUENCE_MUTATOR_H__
#define __SEQUENCE_MUTATOR_H__

// Includes

#include <iostream>
#include <string>
#include <debug.h>
#include <libintl.h> 

using namespace std;

/** produce mutated sequences

    @author Eckart Bindewald
    @review - */
class SequenceMutator {
public:

  enum {GAP_CHAR = '-'};

  SequenceMutator();

  SequenceMutator(const string& s);

  SequenceMutator(const SequenceMutator& orig);

  virtual ~SequenceMutator();

  /* OPERATORS */

  /** Assigment operator. */
  SequenceMutator& operator = (const SequenceMutator& orig);

  friend ostream& operator << (ostream& os,
			       const SequenceMutator& rval);

  /* PREDICATES */

  /** Is current state valid? */
  virtual bool isValid() const;

  string getSequenceCurr() const { return sequenceCurr; }

  int getInsMax() const { return insMax; }

  int getDelMax() const { return delMax; }

  int getShiftMax() const { return shiftMax; }

  bool hasNext() const;
  
  /* MODIFIERS */
  
  void nextSequence();
  
  void reset();
  
protected:
  /* OPERATORS  */
  /* PREDICATES */
  /* MODIFIERS  */
  void copy(const SequenceMutator& other);
  
private:
  /* OPERATORS  */
  
  /* PREDICATES */
  
  /* MODIFIERS  */
  
  /** increases permutation */
  void incPerm();
  
  bool deletionPossible();

  bool insertionPossible();
  
  void updateSequence();

  void initDefault();
  
private:
  /* PRIVATE ATTRIBUTES */
  
  string sequenceOrig;
  string sequenceCurr;
  
  int shift;
  int shiftMax;
  
  int insLen;
  int insMax;
  int insPos;
  
  int delLen;
  int delMax;
  int delPos;
};

#endif /* __ACLASS_H__ */

