#ifndef __SUPERPOSE__
#define __SUPERPOSE__

#include <Vec.h>
#include <Vector3D.h>
#include <Matrix3D.h>

double
superimpose(const Vec<Vector3D>& v1, Vec<Vector3D>& v2, 
	    Matrix3D& m, Vector3D& c1, Vector3D& c2);

/*
  v2 is rotated optimally onto v1
 */
inline
double
superimpose(const Vec<Vector3D>& v1, Vec<Vector3D>& v2) {
  Matrix3D m;
  Vector3D c1, c2;
  return superimpose(v1, v2, m, c1, c2);
}

/*
  v2 is left constant in this convinience method
 */
inline 
double
superimposeRms(const Vec<Vector3D>& v1, const Vec<Vector3D>& v2Orig) {
  Vec<Vector3D> v2 = v2Orig;
  return superimpose(v1, v2);
}

/*
  v2 is rotated optimally onto v1, v3 is transformed according to same rotation and translation
 */
inline
double
superimpose(const Vec<Vector3D>& v1, Vec<Vector3D>& v2, Vec<Vector3D>& v3) {
  Matrix3D m;
  Vector3D c1, c2;
  return superimpose(v1, v2, m, c1, c2);
  // use rotation matrix and shift vector to mutate v3:
/*    for (unsigned int i = 0; i < v3.size(); ++i) { */
/*      v3[i] = ( m * (v3[i] - c2) ) + c1; */
/*    } */
}


#endif
