
#ifndef __GEOM3D_H__
#define __GEOM3D_H__

#include <math.h>
#include <debug.h>
#include <Vector3D.h>

/** return min distance between point and line , defined trough offset and 
    direction
    positive result, if it projects to positive half line, negative otherwise
*/
double
distanceToLine(const Vector3D& point, 
	       const Vector3D& offset, 
	       const Vector3D& direction);

/** returns distance between two lines in 3D space defined
 * through x0+x*t and y0+y*s  .
 * It returns a 3D vector with the 1. component being 
 * "t", the second component being "s" and the third
 * component being the distance d 
 * Formulas from: Paper by Bard, Himel in class of Dr. Dennis Merino
 * (Mississipi College, USA)
 * www.mc.edu/campus/users/travis/maa/proceedings/spring2001/bard.himel.pdf  
 */
Vector3D 
computeLineDistance(const Vector3D& x0,
		    const Vector3D& x,
		    const Vector3D& y0, 
		    const Vector3D& y);

/** return minimum distance between two line segements.
 * Line segment A defined with end points a0 and a1,
 * Line segment B defined with end points b0 and b1.
 * Useful for collision check of two "capsules" (cylinders capped by half spheres).
 * @see: http://www.realtimerendering.com/int/  and http://www.geometrictools.com/
 */
Vector3D 
computeLineSegmentDistance(const Vector3D& a0,
			   const Vector3D& a1,
			   const Vector3D& b0, 
			   const Vector3D& b1);


#endif
